/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.blockpattern;

import com.google.common.base.Preconditions;
import falseresync.lib.blockpattern.BetterBlockPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2694;

public class BetterBlockPatternBuilder {
    protected final List<String[]> layers = new ArrayList<String[]>();
    protected final Map<Character, Predicate<class_2694>> keys = new HashMap<Character, Predicate<class_2694>>();
    protected int width = 0;
    protected int depth = 0;
    protected boolean preserveUp = false;
    protected boolean sidewaysLayers = false;

    public BetterBlockPatternBuilder() {
        this.keys.put(Character.valueOf(' '), pos -> true);
    }

    public BetterBlockPatternBuilder layer(String ... pattern) {
        Preconditions.checkArgument((pattern.length > 0 && !pattern[0].isEmpty() ? 1 : 0) != 0, (Object)"Empty patterns are disallowed");
        if (this.depth == 0) {
            this.depth = pattern.length;
        }
        Preconditions.checkArgument((pattern.length == this.depth ? 1 : 0) != 0, (String)"All layers must have equal depths, but found different: %d and %d", (int)pattern.length, (int)this.depth);
        if (this.width == 0) {
            this.width = pattern[0].length();
        }
        for (String subLayer : pattern) {
            Preconditions.checkArgument((subLayer.length() == this.width ? 1 : 0) != 0, (String)"All sub-layers must have equal widths, but found different: %d and %d", (int)subLayer.length(), (int)this.width);
            for (char key : subLayer.toCharArray()) {
                this.keys.putIfAbsent(Character.valueOf(key), null);
            }
        }
        this.layers.add(pattern);
        return this;
    }

    public BetterBlockPatternBuilder where(char key, Predicate<class_2694> value) {
        this.keys.put(Character.valueOf(key), value);
        return this;
    }

    public BetterBlockPatternBuilder preserveUp() {
        this.preserveUp = true;
        return this;
    }

    public BetterBlockPatternBuilder sidewaysLayers() {
        this.sidewaysLayers = true;
        return this;
    }

    public BetterBlockPattern build() {
        return new BetterBlockPattern(this.bakePredicates(), this.preserveUp);
    }

    protected Predicate<class_2694>[][][] bakePredicates() {
        this.validate();
        int sizeY = this.sidewaysLayers ? this.depth : this.layers.size();
        int sizeZ = this.sidewaysLayers ? this.layers.size() : this.depth;
        Predicate[][][] predicates = new Predicate[this.width][sizeY][sizeZ];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.layers.size(); ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    if (this.sidewaysLayers) {
                        predicates[x][z][y] = this.keys.get(Character.valueOf(this.layers.get(y)[z].charAt(x)));
                        continue;
                    }
                    predicates[x][y][z] = this.keys.get(Character.valueOf(this.layers.get(y)[z].charAt(x)));
                }
            }
        }
        return predicates;
    }

    protected void validate() {
        ArrayList<String> missingValues = new ArrayList<String>();
        for (Map.Entry<Character, Predicate<class_2694>> mapping : this.keys.entrySet()) {
            if (mapping.getValue() != null) continue;
            missingValues.add(mapping.getKey().toString());
        }
        Preconditions.checkState((boolean)missingValues.isEmpty(), (String)"Missing mappings for keys: %s", (Object)String.join((CharSequence)", ", missingValues));
    }
}

