/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.logging;

import org.slf4j.Logger;

public class BetterLogger {
    private final Logger delegate;
    private final String prefix;

    public BetterLogger(Logger logger, String prefix) {
        this.delegate = logger;
        this.prefix = "[%s]".formatted(prefix);
    }

    public Logger getDelegate() {
        return this.delegate;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void trace(Object msg) {
        this.delegate.trace("{} {}", (Object)this.prefix, msg);
    }

    public void debug(Object msg) {
        this.delegate.debug("{} {}", (Object)this.prefix, msg);
    }

    public void info(Object msg) {
        this.delegate.info("{} {}", (Object)this.prefix, msg);
    }

    public void warn(Object msg) {
        this.delegate.warn("{} {}", (Object)this.prefix, msg);
    }

    public void error(Object msg) {
        this.delegate.error("{} {}", (Object)this.prefix, msg);
    }
}

