/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.math;

public class Easing {
    public static double easeInSine(double x) {
        return 1.0 - Math.cos(x * Math.PI / 2.0);
    }

    public static double easeOutSine(double x) {
        return Math.sin(x * Math.PI / 2.0);
    }

    public static double easeInOutSine(double x) {
        return -(Math.cos(Math.PI * x) - 1.0) / 2.0;
    }

    public static double easeInQuad(double x) {
        return x * x;
    }

    public static double easeOutQuad(double x) {
        return 1.0 - (1.0 - x) * (1.0 - x);
    }

    public static double easeInOutQuad(double x) {
        return x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0;
    }

    public static double easeInCubic(double x) {
        return x * x * x;
    }

    public static double easeOutCubic(double x) {
        return 1.0 - Math.pow(1.0 - x, 3.0);
    }

    public static double easeInOutCubic(double x) {
        return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
    }

    public static double easeInQuart(double x) {
        return x * x * x * x;
    }

    public static double easeOutQuart(double x) {
        return 1.0 - Math.pow(1.0 - x, 4.0);
    }

    public static double easeInOutQuart(double x) {
        return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
    }

    public static double easeInQuint(double x) {
        return x * x * x * x * x;
    }

    public static double easeOutQuint(double x) {
        return 1.0 - Math.pow(1.0 - x, 5.0);
    }

    public static double easeInOutQuint(double x) {
        return x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0;
    }

    public static double easeInExpo(double x) {
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }

    public static double easeOutExpo(double x) {
        return x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x);
    }

    public static double easeInOutExpo(double x) {
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0));
    }

    public static double easeInCirc(double x) {
        return 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));
    }

    public static double easeOutCirc(double x) {
        return Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
    }

    public static double easeInOutCirc(double x) {
        return x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0;
    }

    public static double easeInBack(double x) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        return 2.70158 * x * x * x - 1.70158 * x * x;
    }

    public static double easeOutBack(double x) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        return 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0);
    }

    public static double easeInOutBack(double x) {
        double c1 = 1.70158;
        double c2 = 2.5949095;
        return x < 0.5 ? Math.pow(2.0 * x, 2.0) * (7.189819 * x - 2.5949095) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * (3.5949095 * (x * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
    }

    public static double easeInElastic(double x) {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953));
    }

    public static double easeOutElastic(double x) {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0);
    }

    public static double easeInOutElastic(double x) {
        double c5 = 1.3962634015954636;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636) / 2.0 + 1.0));
    }

    public static double easeInBounce(double x) {
        return 1.0 - Easing.easeOutBounce(1.0 - x);
    }

    public static double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 0.36363636363636365) {
            return 7.5625 * x * x;
        }
        if (x < 0.7272727272727273) {
            return 7.5625 * (x -= 0.5454545454545454) * x + 0.75;
        }
        if (x < 0.9090909090909091) {
            return 7.5625 * (x -= 0.8181818181818182) * x + 0.9375;
        }
        return 7.5625 * (x -= 0.9545454545454546) * x + 0.984375;
    }

    public static double easeInOutBounce(double x) {
        return x < 0.5 ? (1.0 - Easing.easeOutBounce(1.0 - 2.0 * x)) / 2.0 : (1.0 + Easing.easeOutBounce(2.0 * x - 1.0)) / 2.0;
    }
}

