/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.math;

import org.apache.commons.lang3.tuple.Pair;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VectorMath {
    public static Pair<Quaternionf, Quaternionf> swingTwistDecomposition(Quaternionf rotation, Vector3f direction) {
        Vector3f rotationAxis = new Vector3f(rotation.x, rotation.y, rotation.z);
        Vector3f projection = VectorMath.vectorProjection(rotationAxis, direction);
        Quaternionf twist = new Quaternionf(projection.x, projection.y, projection.z, rotation.w).normalize();
        Quaternionf swing = rotation.mul((Quaternionfc)twist.conjugate(new Quaternionf()), new Quaternionf());
        return Pair.ofNonNull((Object)swing, (Object)twist);
    }

    public static Vector3f vectorProjection(Vector3f a, Vector3f b) {
        return b.mul(VectorMath.scalarProjection(a, b));
    }

    public static float scalarProjection(Vector3f a, Vector3f b) {
        return a.length() * a.angleCos((Vector3fc)b);
    }
}

