/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.registry;

import falseresync.lib.logging.BetterLogger;
import falseresync.lib.registry.RegistryObject;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class AutoRegistry {
    private final String modId;
    private final BetterLogger logger;

    public AutoRegistry(String modId, BetterLogger logger) {
        this.modId = modId;
        this.logger = logger;
    }

    public <T> AutoRegistry link(class_2378<T> registry, Class<?> ... holderClasses) {
        int classesNoFound = holderClasses.length;
        int classesNoRegistered = 0;
        int fieldsNoFound = 0;
        int fieldsNoRegistered = 0;
        for (Class<?> holderClass : holderClasses) {
            Field[] fields = holderClass.getDeclaredFields();
            int fieldsNoCurrentlyFound = fields.length;
            int fieldsNoCurrentlyRegistered = 0;
            for (Field field : fields) {
                int modifiers = field.getModifiers();
                RegistryObject[] annotations = (RegistryObject[])field.getAnnotationsByType(RegistryObject.class);
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || annotations.length == 0) continue;
                try {
                    Object registryObject = field.get(holderClass);
                    if (registryObject == null) {
                        this.logger.warn("Found a null @RegistryObject field, discarding: %s at %s".formatted(field.getName(), holderClass.getCanonicalName()));
                        continue;
                    }
                    class_2378.method_10230(registry, (class_2960)class_2960.method_60655((String)this.modId, (String)field.getName().toLowerCase()), (Object)registryObject);
                    ++fieldsNoCurrentlyRegistered;
                }
                catch (IllegalAccessException e) {
                    throw new InaccessibleObjectException("Couldn't read a @RegistryObject field: %s at %s".formatted(field.getName(), holderClass.getCanonicalName()));
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("A @RegistryObject field's type doesn't match the provided registry: %s at %s".formatted(field.getName(), holderClass.getCanonicalName()));
                }
            }
            if (fieldsNoCurrentlyFound > 0) {
                fieldsNoFound += fieldsNoCurrentlyFound;
                if (fieldsNoCurrentlyRegistered > 0) {
                    fieldsNoRegistered += fieldsNoCurrentlyRegistered;
                    ++classesNoRegistered;
                    continue;
                }
                this.logger.warn("Found a class with no valid @RegistryObjects: %s".formatted(holderClass.getCanonicalName()));
                continue;
            }
            this.logger.warn("Found a class without any fields: %s".formatted(holderClass.getCanonicalName()));
        }
        if (classesNoRegistered == 0) {
            this.logger.warn("Nothing got registered into %s because there are no holder classes with valid @RegistryObject fields".formatted(registry.method_30517()));
        }
        this.logger.debug("Registered %s valid @RegistryObjects into registry %s from %s holder classes with %s fields".formatted(fieldsNoRegistered, registry.method_30517(), classesNoFound, fieldsNoFound));
        return this;
    }
}

