/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client;

import dev.emi.trinkets.api.event.TrinketDropCallback;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import falseresync.wizcraft.client.ClientInventoryEvents;
import falseresync.wizcraft.client.WizcraftClient;
import falseresync.wizcraft.client.hud.ChargeDisplayHudItem;
import falseresync.wizcraft.client.hud.FocusPickerHudItem;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import falseresync.wizcraft.common.item.WizcraftItems;
import falseresync.wizcraft.networking.c2s.ChangeWandFocusC2SPayload;
import falseresync.wizcraft.networking.c2s.WandFocusDestination;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class ToolManager {
    private final ChargeDisplayHudItem chargeDisplay = WizcraftClient.getHud().getChargeDisplay();
    private final FocusPickerHudItem focusPicker = WizcraftClient.getHud().getFocusPicker();

    public ToolManager() {
        TrinketEquipCallback.EVENT.register((stack, slot, entity) -> {
            class_1657 player;
            class_1799 wandStack;
            if (entity instanceof class_1657 && (wandStack = this.scanInventoryForWands((player = (class_1657)entity).method_31548())) != null) {
                this.setupChargeDisplay(player, wandStack);
            }
        });
        TrinketDropCallback.EVENT.register((rule, stack, ref, entity) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                this.hideChargeDisplayIfShould(player);
            }
            return rule;
        });
        TrinketUnequipCallback.EVENT.register((stack, slot, entity) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                this.hideChargeDisplayIfShould(player);
            }
        });
        ClientInventoryEvents.SELECTED_SLOT_CHANGED.register((inventory, lastSelectedSlot) -> {
            class_1799 wandStack = this.scanInventoryForWands(inventory);
            if (wandStack != null) {
                this.setupChargeDisplay(inventory.field_7546, wandStack);
            } else {
                this.chargeDisplay.hide();
                this.focusPicker.hide();
            }
        });
        ClientInventoryEvents.CONTENTS_CHANGED.register(inventory -> {
            class_1799 wandStack = this.scanInventoryForWands(inventory);
            if (wandStack != null) {
                this.setupChargeDisplay(inventory.field_7546, wandStack);
                this.scanInventoryAndSetupFocusPicker(inventory, wandStack, false);
            } else {
                this.chargeDisplay.hide();
                this.focusPicker.hide();
            }
        });
    }

    public void onKeyPressed(class_310 client, class_746 player) {
        class_1799 wandStack = this.scanInventoryForWands(player.method_31548());
        if (wandStack == null) {
            this.focusPicker.hide();
            return;
        }
        this.scanInventoryAndSetupFocusPicker(player.method_31548(), wandStack, true);
    }

    @Nullable
    private class_1799 scanInventoryForWands(class_1661 inventory) {
        class_1799 wandStack = inventory.method_7391();
        return wandStack.method_31573(WizcraftItemTags.WANDS) ? wandStack : null;
    }

    private void setupChargeDisplay(class_1657 player, class_1799 wandStack) {
        if (player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            this.chargeDisplay.upload(wandStack);
            this.chargeDisplay.show();
        }
    }

    private void hideChargeDisplayIfShould(class_1657 player) {
        if (this.chargeDisplay.isVisible() && !player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            this.chargeDisplay.hide();
        }
    }

    private void scanInventoryAndSetupFocusPicker(class_1661 inventory, class_1799 wandStack, boolean shouldPickNext) {
        class_1799 equipped = (class_1799)wandStack.method_57825(WizcraftComponents.EQUIPPED_FOCUS_ITEM, (Object)class_1799.field_8037);
        Optional<class_1799> belt = WizcraftItems.FOCUSES_BELT.findTrinketStack(inventory.field_7546);
        LinkedList focusStacks = belt.map(it -> WizcraftItems.FOCUSES_BELT.getOrCreateInventoryComponent((class_1799)it).stacks().stream().filter(stack -> !stack.method_7960())).orElseGet(() -> inventory.field_7547.stream().filter(it -> it.method_31573(WizcraftItemTags.FOCUSES))).collect(Collectors.toCollection(LinkedList::new));
        if (!equipped.method_7960()) {
            focusStacks.addFirst(equipped);
        }
        if (focusStacks.isEmpty()) {
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43471((String)"hud.wizcraft.wand.no_focuses"), false);
            return;
        }
        class_1799 picked = this.setupFocusPicker(wandStack, focusStacks, equipped, shouldPickNext);
        if (picked != null) {
            if (belt.isPresent()) {
                Integer slot = belt.map(WizcraftItems.FOCUSES_BELT::getOrCreateInventoryComponent).map(component -> component.getSlotWithStack(picked)).orElse(-1);
                ClientPlayNetworking.send((class_8710)new ChangeWandFocusC2SPayload(WandFocusDestination.FOCUSES_BELT, slot));
            } else {
                int slot = inventory.method_7395(picked);
                ClientPlayNetworking.send((class_8710)new ChangeWandFocusC2SPayload(WandFocusDestination.PLAYER_INVENTORY, slot));
            }
        }
    }

    @Nullable
    private class_1799 setupFocusPicker(class_1799 wandStack, LinkedList<class_1799> focusStacks, class_1799 equipped, boolean shouldPickNext) {
        this.focusPicker.upload(wandStack, focusStacks);
        if (shouldPickNext) {
            if (this.focusPicker.isVisible() || equipped.method_7960()) {
                this.focusPicker.pickNext();
            }
            this.focusPicker.show();
            class_1799 picked = this.focusPicker.getCurrentlyPicked();
            return class_1799.method_31577((class_1799)equipped, (class_1799)picked) ? null : picked;
        }
        return null;
    }
}

