/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import falseresync.lib.client.BetterGuiGraphics;
import falseresync.lib.math.Easing;
import falseresync.wizcraft.client.hud.HudItem;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.ChargeShellsAttachment;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5253;
import net.minecraft.class_9779;

public class ChargeDisplayHudItem
implements HudItem {
    protected static final class_2960 BAR_TEX = Wizcraft.wid("textures/hud/wand/charge_bar.png");
    protected static final class_2960 OVERLAY_TEX = Wizcraft.wid("textures/hud/wand/charge_bar_overlay.png");
    protected static final class_2960 SHELL_TEX = Wizcraft.wid("textures/hud/wand/charge_shell.png");
    private static final int WIDGET_W = 16;
    private static final int WIDGET_H = 64;
    private static final int TEX_W = 16;
    private static final int TEX_H = 64;
    private static final int SHELL_W = 16;
    private static final int SHELL_H = 16;
    private static final int OVERLAY_U = 7;
    private static final int OVERLAY_V = 16;
    private static final int OVERLAY_W = 2;
    private static final int OVERLAY_H = 32;
    private static final int ANIMATION_DURATION = 10;
    private static final int SHELL_NO_CHARGE_TINT = -1426063361;
    private static final int SHELL_FULL_CHARGE_TINT = -16728065;
    private final class_310 client;
    private final class_327 textRenderer;
    private int currentCharge = 0;
    private int maxCharge = 0;
    private int chargeInShells = -1;
    private int maxChargeInShells = -1;
    private boolean isVisible = false;
    private class_1799 wand;
    private boolean animating = false;
    private int remainingAnimationTicks = 0;

    public ChargeDisplayHudItem(class_310 client, class_327 textRenderer) {
        this.client = client;
        this.textRenderer = textRenderer;
    }

    @Override
    public void render(BetterGuiGraphics context, class_9779 tickCounter) {
        if (this.isVisible() || this.animating) {
            float opacity = this.getAnimatedOpacity();
            float x = this.getAnimatedX();
            float y = (float)context.method_51443() / 2.0f - 32.0f;
            RenderSystem.enableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, opacity);
            if (this.maxChargeInShells >= 0) {
                int tint = class_5253.class_5254.method_48780((float)((float)this.chargeInShells / (float)this.maxChargeInShells), (int)-1426063361, (int)-16728065);
                context.method_51422((float)class_5253.class_5254.method_27765((int)tint) / 255.0f, (float)class_5253.class_5254.method_27766((int)tint) / 255.0f, (float)class_5253.class_5254.method_27767((int)tint) / 255.0f, (float)class_5253.class_5254.method_27762((int)tint) / 255.0f * opacity);
                context.drawNonDiscreteRect(SHELL_TEX, x, y - 16.0f, 16, 16);
                context.method_51422(1.0f, 1.0f, 1.0f, opacity);
            }
            context.drawNonDiscreteRect(BAR_TEX, x, y, 16, 64);
            int step = this.getStep();
            int v = 16 + step;
            int h = 32 - step;
            context.drawNonDiscreteRect(OVERLAY_TEX, x, y, 7, v, 2, h, 16, 64);
            RenderSystem.disableBlend();
        }
    }

    private float getAnimatedOpacity() {
        if (this.animating) {
            return this.isVisible() ? 1.0f - (float)this.remainingAnimationTicks / 10.0f : (float)this.remainingAnimationTicks / 10.0f;
        }
        return 1.0f;
    }

    private float getAnimatedX() {
        if (this.animating) {
            return this.isVisible() ? (float)(2.0 - (double)this.remainingAnimationTicks * Easing.easeInOutCubic((double)this.remainingAnimationTicks / 10.0)) : (float)(2.0 - (10.0 - (double)this.remainingAnimationTicks * Easing.easeInOutCubic((double)this.remainingAnimationTicks / 10.0)));
        }
        return 2.0f;
    }

    private int getStep() {
        return Math.clamp((long)Math.round(32.0f - (float)(this.currentCharge * 32) / (float)this.maxCharge), 0, 32);
    }

    @Override
    public void tick() {
        if (this.client.field_1724 == null) {
            this.clear();
            return;
        }
        if (this.wand != null) {
            this.currentCharge = (Integer)this.wand.method_57825(WizcraftComponents.WAND_CHARGE, (Object)0);
            this.maxCharge = (Integer)this.wand.method_57825(WizcraftComponents.WAND_MAX_CHARGE, (Object)0);
            ChargeShellsAttachment shells = (ChargeShellsAttachment)this.client.field_1724.getAttached(WizcraftAttachments.CHARGE_SHELLS);
            if (shells != null) {
                this.chargeInShells = shells.currentCharge();
                this.maxChargeInShells = shells.maxCharge();
            }
        }
        if (this.remainingAnimationTicks > 0) {
            --this.remainingAnimationTicks;
            if (this.remainingAnimationTicks == 0) {
                this.animating = false;
                if (!this.isVisible()) {
                    this.clear();
                }
            }
        }
    }

    public void show() {
        if (!this.isVisible) {
            this.animate();
        }
        this.isVisible = true;
    }

    public void hide() {
        if (this.isVisible()) {
            this.animate();
        }
        this.isVisible = false;
        this.wand = null;
    }

    private void clear() {
        this.isVisible = false;
        this.wand = null;
        this.currentCharge = 0;
        this.maxCharge = 0;
        this.chargeInShells = 0;
        this.maxChargeInShells = 0;
    }

    private void animate() {
        this.animating = true;
        this.remainingAnimationTicks = 10;
    }

    public void upload(class_1799 stack) {
        this.wand = stack;
    }

    public boolean isVisible() {
        return this.isVisible && this.wand != null;
    }

    public int getWidth() {
        return 16;
    }
}

