/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import falseresync.lib.client.BetterGuiGraphics;
import falseresync.lib.math.Easing;
import falseresync.wizcraft.client.WizcraftClient;
import falseresync.wizcraft.client.hud.ChargeDisplayHudItem;
import falseresync.wizcraft.client.hud.HudItem;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.focus.FocusItem;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import org.joml.Matrix4f;

public class FocusPickerHudItem
implements HudItem {
    protected static final class_2960 SELECTION_TEX = Wizcraft.wid("textures/hud/wand/focus_picker_selection.png");
    private static final int MARGIN = 2;
    private static final int WIDGET_W = 22;
    private static final int WIDGET_H = 22;
    private static final int TEX_SIZE = 22;
    private static final int ITEM_W = 16;
    private static final int ITEM_H = 16;
    private static final int TEXT_H = 8;
    private static final int DISPLAY_DURATION = 60;
    private static final int PARENT_ANIMATION_DURATION = 8;
    private static final int ITEMS_ANIMATION_DURATION = 6;
    private static final Comparator<class_1799> FOCUS_ORDERING = Comparator.comparingInt(stack -> ((FocusItem)stack.method_7909()).getRawId()).thenComparingInt(stack -> (Integer)stack.method_57825(WizcraftComponents.FOCUS_PLATING, (Object)-1)).thenComparingLong(stack -> ((UUID)stack.method_57825(WizcraftComponents.UUID, (Object)UUID.randomUUID())).getMostSignificantBits());
    private final class_310 client;
    private final class_327 textRenderer;
    private final LinkedList<class_1799> focuses = new LinkedList();
    private class_1799 wand;
    private float baseOpacity = 1.0f;
    private boolean isVisible = false;
    private int remainingDisplayTicks = 0;
    private boolean animatingParent = false;
    private int remainingParentAnimationTicks = 0;
    private boolean animatingItems = false;
    private int remainingItemsAnimationTicks = 0;

    public FocusPickerHudItem(class_310 client, class_327 textRenderer) {
        this.client = client;
        this.textRenderer = textRenderer;
    }

    @Override
    public void render(BetterGuiGraphics context, class_9779 tickCounter) {
        if (this.isVisible() || this.animatingParent) {
            this.baseOpacity = this.getAnimatedBaseOpacity();
            int yOffsetPerItem = 18;
            int yOffset = (Math.min(this.focuses.size(), 3) - 1) * yOffsetPerItem;
            int widgetH = 22 + yOffset;
            ChargeDisplayHudItem chargeDisplay = WizcraftClient.getHud().getChargeDisplay();
            int x = 4 + (chargeDisplay.isVisible() ? chargeDisplay.getWidth() : 0);
            int y = context.method_51443() / 2 - widgetH / 2;
            RenderSystem.enableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, this.baseOpacity);
            context.drawSquare(SELECTION_TEX, x, y + yOffset, 22, 22);
            int itemX = x + 11 - 8;
            if (this.animatingItems) {
                class_1799 item1 = this.addGlintIfNecessary(this.focuses.peekLast());
                int item1Y = y + 11 - 8 + yOffset;
                float item1Scale = (float)Easing.easeOutCirc((double)this.remainingItemsAnimationTicks / 6.0);
                float item1Translation = (float)(22.0 * Easing.easeInSine((double)(6 - this.remainingItemsAnimationTicks) / 6.0));
                float item1Opacity = this.baseOpacity * (float)this.remainingItemsAnimationTicks / 6.0f;
                this.paintItem(context, item1, itemX, item1Y, item1Scale, item1Translation, item1Opacity, false);
                if (this.focuses.size() > 1) {
                    class_1799 item2 = this.addGlintIfNecessary(this.focuses.getFirst());
                    int item2Y = y + Math.min(this.focuses.size() - 2, 1) * yOffsetPerItem + yOffsetPerItem / 2 - 8;
                    float item2Scale = 0.85f + 0.14999998f * (float)Easing.easeOutSine((double)(6 - this.remainingItemsAnimationTicks) / 6.0);
                    float item2Translation = (float)((double)yOffsetPerItem * Easing.easeInOutSine((double)(6 - this.remainingItemsAnimationTicks) / 6.0));
                    this.paintItem(context, item2, itemX, item2Y, item2Scale, item2Translation, this.baseOpacity, false);
                }
                if (this.focuses.size() > 2) {
                    class_1799 item3 = this.focuses.get(1);
                    int item3Y = y + yOffsetPerItem / 2 - 8;
                    float item3Scale = 0.7f * (float)Easing.easeOutSine((double)(6 - this.remainingItemsAnimationTicks) / 6.0);
                    float item3Translation = (float)((double)yOffsetPerItem * Easing.easeInOutSine((double)(6 - this.remainingItemsAnimationTicks) / 6.0));
                    this.paintItem(context, item3, itemX, item3Y, item3Scale, item3Translation, this.baseOpacity, false);
                    class_1799 item4 = this.focuses.get(2);
                    int item4Y = y + yOffsetPerItem / 2 - 8;
                    float item4Scale = 0.7f * (float)Easing.easeInOutQuad((double)(6 - this.remainingItemsAnimationTicks) / 6.0);
                    this.paintItem(context, item4, itemX, item4Y, item4Scale, 0.0f, this.baseOpacity / 2.0f, true);
                }
            } else {
                class_1799 item1 = this.addGlintIfNecessary(this.focuses.getFirst());
                int item1Y = y + 11 - 8 + yOffset;
                this.paintItem(context, item1, itemX, item1Y, 1.0f, 0.0f, this.baseOpacity, false);
                if (this.focuses.size() > 1) {
                    class_1799 item2 = this.focuses.get(1);
                    int item2Y = y + Math.min(this.focuses.size() - 2, 1) * yOffsetPerItem + yOffsetPerItem / 2 - 8;
                    this.paintItem(context, item2, itemX, item2Y, 0.85f, 0.0f, this.baseOpacity, false);
                }
                if (this.focuses.size() > 2) {
                    class_1799 item3 = this.focuses.get(2);
                    int item3Y = y + yOffsetPerItem / 2 - 8;
                    this.paintItem(context, item3, itemX, item3Y, 0.7f, 0.0f, this.baseOpacity, true);
                }
            }
            RenderSystem.disableBlend();
        }
    }

    protected class_1799 addGlintIfNecessary(class_1799 stack) {
        class_1799 stackWithGlint = null;
        if (this.wand.method_7958() && stack != null) {
            stackWithGlint = stack.method_7972();
            stackWithGlint.method_57379(class_9334.field_49641, (Object)true);
        }
        return stackWithGlint == null ? stack : stackWithGlint;
    }

    protected void paintItem(BetterGuiGraphics context, class_1799 stack, int x, int y, float scale, float translation, float opacity, boolean shouldTint) {
        class_4587 poseStack = context.method_51448();
        poseStack.method_22903();
        poseStack.method_34425(new Matrix4f().scaleAround(scale, scale, 1.0f, (float)x + 8.0f, (float)y + 8.0f, 0.0f));
        poseStack.method_46416(0.0f, translation, 0.0f);
        if (shouldTint) {
            context.method_51422(0.6313726f, 0.61960787f, 0.6666667f, opacity);
        } else {
            context.method_51422(1.0f, 1.0f, 1.0f, opacity);
        }
        context.method_51445(stack, x, y);
        context.method_51431(this.textRenderer, stack, x, y);
        context.method_51422(1.0f, 1.0f, 1.0f, this.baseOpacity);
        poseStack.method_22909();
    }

    private float getAnimatedBaseOpacity() {
        if (this.animatingParent) {
            return this.isVisible() ? 1.0f - (float)this.remainingParentAnimationTicks / 8.0f : (float)this.remainingParentAnimationTicks / 8.0f;
        }
        return 1.0f;
    }

    @Override
    public void tick() {
        if (this.client.field_1724 == null) {
            this.clear();
            return;
        }
        if (this.remainingDisplayTicks > 0) {
            --this.remainingDisplayTicks;
            if (this.remainingDisplayTicks == 0) {
                this.hide();
            }
        }
        if (this.remainingParentAnimationTicks > 0) {
            --this.remainingParentAnimationTicks;
            if (this.remainingParentAnimationTicks == 0) {
                this.animatingParent = false;
                if (this.remainingDisplayTicks == 0) {
                    this.clear();
                }
            }
        }
        if (this.remainingItemsAnimationTicks > 0) {
            --this.remainingItemsAnimationTicks;
            if (this.remainingItemsAnimationTicks == 0) {
                this.animatingItems = false;
            }
        }
    }

    public void show() {
        if (!this.isVisible()) {
            this.animateParent();
        }
        this.isVisible = true;
        this.remainingDisplayTicks = 60;
    }

    public void hide() {
        if (this.isVisible()) {
            this.animateParent();
        }
        this.isVisible = false;
    }

    private void clear() {
        this.isVisible = false;
        this.wand = null;
        this.focuses.clear();
    }

    private void animateParent() {
        this.animatingParent = true;
        this.remainingParentAnimationTicks = 8;
    }

    private void animateItems() {
        this.animatingItems = true;
        this.remainingItemsAnimationTicks = 6;
    }

    public void upload(class_1799 wand, LinkedList<class_1799> newFocuses) {
        this.wand = wand;
        this.focuses.clear();
        this.focuses.addAll(newFocuses);
        this.focuses.sort(FOCUS_ORDERING);
        while (!Objects.equals(newFocuses.getFirst().method_57824(WizcraftComponents.UUID), this.focuses.getFirst().method_57824(WizcraftComponents.UUID))) {
            this.focuses.addLast(this.focuses.removeFirst());
        }
        this.getCurrentlyPicked();
    }

    public void pickNext() {
        if (this.focuses.size() > 1) {
            this.focuses.addLast(this.focuses.removeFirst());
            this.animateItems();
        }
    }

    public class_1799 getCurrentlyPicked() {
        return this.focuses.getFirst();
    }

    public boolean isVisible() {
        return this.isVisible && !this.focuses.isEmpty() && this.wand != null;
    }
}

