/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.hud;

import falseresync.lib.client.BetterGuiGraphics;
import falseresync.wizcraft.client.hud.ChargeDisplayHudItem;
import falseresync.wizcraft.client.hud.FocusPickerHudItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class WizcraftHud {
    private final class_310 client;
    private final FocusPickerHudItem focusPicker;
    private final ChargeDisplayHudItem chargeDisplay;

    public WizcraftHud(class_310 minecraft) {
        this.client = minecraft;
        this.focusPicker = new FocusPickerHudItem(minecraft, minecraft.field_1772);
        this.chargeDisplay = new ChargeDisplayHudItem(minecraft, minecraft.field_1772);
        this.initEventListeners();
    }

    private void initEventListeners() {
        HudRenderCallback.EVENT.register((vanillaContext, tickCounter) -> {
            BetterGuiGraphics context = new BetterGuiGraphics(this.client, vanillaContext);
            this.focusPicker.render(context, tickCounter);
            this.chargeDisplay.render(context, tickCounter);
        });
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            if (this.client.method_1493()) {
                return;
            }
            this.focusPicker.tick();
            this.chargeDisplay.tick();
        });
    }

    public FocusPickerHudItem getFocusPicker() {
        return this.focusPicker;
    }

    public ChargeDisplayHudItem getChargeDisplay() {
        return this.chargeDisplay;
    }
}

