/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.render.blockentity;

import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftParticleTypes;
import falseresync.wizcraft.common.blockentity.CraftingWorktableBlockEntity;
import falseresync.wizcraft.common.blockentity.LensingPedestalBlockEntity;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_827;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class CraftingWorktableRenderer
implements class_827<CraftingWorktableBlockEntity> {
    protected final class_918 itemRenderer;

    public CraftingWorktableRenderer(class_5614.class_5615 ctx) {
        this.itemRenderer = ctx.method_43335();
    }

    protected static void animateCraftingProgress(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, List<RenderingData> pedestals, class_1937 level, class_918 itemRenderer, float partialTick, class_4587 poseStack, class_4597 bufferSource) {
        class_5819 random = level.method_8409();
        if (progress.remainingCraftingTime() > 10) {
            for (RenderingData pedestal : pedestals) {
                CraftingWorktableRenderer.addParticleBeam(worktable, progress, pedestal, level, partialTick);
            }
        }
        if (progress.remainingCraftingTime() > 10 && progress.passedCraftingTime() > 5) {
            for (RenderingData pedestal : pedestals) {
                CraftingWorktableRenderer.addParticleHurricane(worktable, progress, pedestal, level, partialTick);
            }
        }
        for (RenderingData pedestal : pedestals) {
            CraftingWorktableRenderer.addDisintegrationParticles(level, random, pedestal, progress);
        }
        if (progress.remainingCraftingTime() < 40) {
            CraftingWorktableRenderer.addDisintegrationParticles(level, random, worktable, progress);
            if (progress.remainingCraftingTime() < 10) {
                CraftingWorktableRenderer.addDisintegrationParticles(level, random, worktable, progress);
            }
        }
        if (progress.remainingCraftingTime() > 5) {
            CraftingWorktableRenderer.levitateItems(worktable, progress.value(), pedestals, level, itemRenderer, partialTick, poseStack, bufferSource);
        }
        if (progress.remainingCraftingTime() < 30 && !progress.currentlyCrafted().method_7960()) {
            class_243 scale = RenderingUtil.getSymmetricVec3d(CraftingWorktableRenderer.getCraftingResultScaleForProgress(progress.value()));
            RenderingUtil.levitateItemAboveBlock(level, worktable.pos, class_243.field_1353, scale, partialTick, progress.currentlyCrafted(), itemRenderer, poseStack, bufferSource);
        }
    }

    protected static double getCraftingResultScaleForProgress(double p) {
        return -1.0 / (19.0 * p - 20.0);
    }

    protected static void levitateItems(RenderingData worktable, float craftingProgress, List<RenderingData> pedestals, class_1937 level, class_918 itemRenderer, float partialTick, class_4587 poseStack, class_4597 bufferSource) {
        class_243 scale = RenderingUtil.getSymmetricVec3d(1.0f - craftingProgress);
        RenderingUtil.levitateItemAboveBlock(level, worktable.pos, class_243.field_1353, scale, partialTick, worktable.stack, itemRenderer, poseStack, bufferSource);
        for (RenderingData pedestal : pedestals) {
            class_243 translation = worktable.above.method_1035(pedestal.above);
            RenderingUtil.levitateItemAboveBlock(level, pedestal.pos, translation, scale, partialTick, pedestal.stack, itemRenderer, poseStack, bufferSource);
        }
    }

    protected static double getVelocityForProgress(double p) {
        return 0.2 * (-0.4 - 1.05 / (1.0 * (1.1 * Math.log10(-2.0 * p + 2.0) + 1.0 * (2.0 * p - 2.0))));
    }

    protected static void addParticleBeam(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, RenderingData pedestal, class_1937 level, float partialTick) {
        if (pedestal.stack.method_7960()) {
            return;
        }
        if (level.field_9229.method_43057() < Wizcraft.getConfig().animationParticlesAmount.modifier) {
            float temporalOffset = Math.abs(class_3532.method_15374((float)((float)progress.remainingCraftingTime() + partialTick)));
            class_243 path = pedestal.above.method_1035(worktable.above);
            class_243 pos = pedestal.above.method_1019(path.method_1021(Math.min(0.6, (double)(temporalOffset * progress.value()))));
            class_243 velocity = path.method_1029().method_1021(CraftingWorktableRenderer.getVelocityForProgress(progress.value()));
            RenderingUtil.addParticle(level, pedestal.particleOptions, pos, velocity);
        }
    }

    protected static double getRadiusForProgress(double p) {
        return 1.75 * (-4.3 / (3.6 * p - 6.35) - 1.85 * p + 0.3);
    }

    protected static void addParticleHurricane(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, RenderingData pedestal, class_1937 level, float partialTick) {
        if (pedestal.stack.method_7960()) {
            return;
        }
        float temporalOffset = Math.abs(class_3532.method_15374((float)((float)progress.remainingCraftingTime() + partialTick)));
        int i = 0;
        while ((float)i < (1.0f - progress.value()) * 3.0f * Wizcraft.getConfig().animationParticlesAmount.modifier) {
            float theta = (float)Math.PI * 2 * temporalOffset + (float)i * temporalOffset;
            double r = CraftingWorktableRenderer.getRadiusForProgress(progress.value());
            double hx = r * (double)class_3532.method_15362((float)theta);
            double hz = r * (double)class_3532.method_15374((float)theta);
            class_243 pos = worktable.above.method_1031(hx, 0.0, hz);
            class_243 velocity = new class_243(hz, 0.0, -hx).method_1029().method_1021(CraftingWorktableRenderer.getVelocityForProgress(progress.value()));
            class_243 randomizedPos = pos.method_1031(hx / 16.0 * (double)level.field_9229.method_43057(), (level.field_9229.method_43059() - 0.5) / 16.0, hz / 16.0 * (double)level.field_9229.method_43057());
            RenderingUtil.addParticle(level, pedestal.particleOptions, randomizedPos, velocity);
            ++i;
        }
    }

    protected static void addDisintegrationParticles(class_1937 level, class_5819 random, RenderingData renderingData, CraftingWorktableBlockEntity.Progress progress) {
        if (renderingData.stack.method_7960()) {
            return;
        }
        class_243 velocity = new class_243(((double)random.method_43057() - 0.5) / 8.0, random.method_43059() / 16.0, ((double)random.method_43057() - 0.5) / 8.0);
        float amount = progress.value() * 10.0f * Wizcraft.getConfig().animationParticlesAmount.modifier * (float)(renderingData.stack.method_7909() instanceof class_1747 ? 3 : 1);
        int i = 0;
        while ((float)i < amount) {
            RenderingUtil.addParticle(level, renderingData.particleOptions, renderingData.above, velocity);
            ++i;
        }
    }

    public void render(CraftingWorktableBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1937 world = blockEntity.method_10997();
        if (world == null) {
            return;
        }
        RenderingData worktable = new RenderingData(blockEntity.method_11016(), blockEntity.getHeldStackCopy());
        CraftingWorktableBlockEntity.Progress progress = blockEntity.getProgress();
        List<RenderingData> pedestals = blockEntity.getNonEmptyPedestalPositions().stream().map(arg_0 -> ((class_1937)world).method_8321(arg_0)).flatMap(it -> {
            Stream<Object> stream;
            if (it instanceof LensingPedestalBlockEntity) {
                LensingPedestalBlockEntity pedestal = (LensingPedestalBlockEntity)((Object)it);
                stream = Stream.of(pedestal);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).map(pedestal -> new RenderingData(pedestal.method_11016(), pedestal.getHeldStackCopy())).toList();
        if (pedestals.isEmpty() && worktable.stack.method_7960()) {
            return;
        }
        poseStack.method_22903();
        if (progress.remainingCraftingTime() > 0) {
            CraftingWorktableRenderer.animateCraftingProgress(worktable, progress, pedestals, world, this.itemRenderer, partialTick, poseStack, bufferSource);
        } else {
            CraftingWorktableRenderer.levitateItems(worktable, 0.0f, pedestals, world, this.itemRenderer, partialTick, poseStack, bufferSource);
        }
        poseStack.method_22909();
    }

    public record RenderingData(class_2338 pos, class_243 center, class_243 above, class_1799 stack, @Nullable class_2394 particleOptions) {
        private RenderingData(class_2338 pos, class_1799 stack) {
            this(pos, pos.method_46558(), pos.method_46558().method_1031(0.0, 0.75, 0.0), stack, (class_2394)(stack.method_7960() ? null : new class_2392(WizcraftParticleTypes.SPAGHETTIFICATION, stack)));
        }
    }
}

