/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.render.entity;

import falseresync.lib.math.VectorMath;
import falseresync.wizcraft.client.render.entity.EnergyVeilModel;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.entity.EnergyVeilEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EnergyVeilFeatureRenderer<T extends class_1657>
extends class_3887<T, class_591<T>> {
    public static final class_2960 TEXTURE = Wizcraft.wid("textures/entity/energy_veil.png");
    public static final class_5601 LAYER = new class_5601(Wizcraft.wid("energy_veil"), "main");
    private final EnergyVeilModel model;
    private final class_1921 renderLayer;

    public EnergyVeilFeatureRenderer(class_3883<T, class_591<T>> context, class_5599 loader) {
        super(context);
        this.model = new EnergyVeilModel(loader.method_32072(LAYER));
        this.renderLayer = class_1921.method_42600((class_2960)TEXTURE);
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, T entity, float limbAngle, float limbDistance, float partialTick, float animationProgress, float headYaw, float headPitch) {
        EnergyVeilEntity veil = this.findVeil(entity);
        if (veil == null) {
            return;
        }
        poseStack.method_22903();
        class_4588 buffer = bufferSource.getBuffer(this.renderLayer);
        this.model.animateModel(veil, limbAngle, limbDistance, partialTick);
        for (int i = 0; i < 4; ++i) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)(i * 45)));
            poseStack.method_46416(-veil.getVeilVisibleRadius(), -1.0f, 0.0f);
            this.model.method_60879(poseStack, buffer, packedLight, class_4608.field_21444);
            poseStack.method_46416(veil.getVeilVisibleRadius() * 2.0f, 0.0f, 0.0f);
            this.model.method_60879(poseStack, buffer, packedLight, class_4608.field_21444);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    public void renderInFirstPerson(class_4587 poseStack, class_4597 bufferSource, int packedLight, T entity, float partialTick, float animationProgress) {
        EnergyVeilEntity veil = this.findVeil(entity);
        if (veil == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_34426();
        class_4588 buffer = bufferSource.getBuffer(this.renderLayer);
        this.model.animateModel(veil, 0.0f, 0.0f, partialTick);
        Quaternionf rotation = class_310.method_1551().field_1773.method_19418().method_23767();
        Vector3f direction = class_2350.field_11036.method_23955();
        Pair<Quaternionf, Quaternionf> swingAndTwist = VectorMath.swingTwistDecomposition(rotation, direction);
        poseStack.method_22907((Quaternionf)swingAndTwist.getRight());
        for (int i = 0; i < 3; ++i) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)(45 + i * 45)));
            poseStack.method_46416(veil.getVeilVisibleRadius(), -1.0f, 0.0f);
            this.model.method_2828(poseStack, buffer, packedLight, class_4608.field_21444, (int)(68.0f / Wizcraft.getConfig().fullscreenEffectsTransparency.modifier) << 24 | 0xFFFFFF);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    @Nullable
    private EnergyVeilEntity findVeil(T entity) {
        return Optional.ofNullable((Integer)entity.getAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID)).map(id -> entity.method_5770().method_8469(id.intValue())).flatMap(foundEntity -> {
            Optional<Object> optional;
            if (foundEntity instanceof EnergyVeilEntity) {
                EnergyVeilEntity veil = (EnergyVeilEntity)((Object)foundEntity);
                optional = Optional.of(veil);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).orElse(null);
    }

    public static interface Accessor {
        public EnergyVeilFeatureRenderer<class_742> wizcraft$getEnergyVeilRenderer();
    }
}

