/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.client.render.world;

import falseresync.lib.math.Color;
import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class CometWarpBeaconRenderer
implements WorldRenderEvents.AfterEntities,
WorldRenderEvents.End {
    private static final class_1921 BASE_LAYER = class_1921.method_42600((class_2960)Wizcraft.wid("textures/world/comet_warp_beacon.png"));
    private static final class_1921 REMOTE_LAYER = class_1921.method_42600((class_2960)Wizcraft.wid("textures/world/comet_warp_beacon_remote.png"));
    private static final class_4730 CROWN_TEX = new class_4730(class_1059.field_5275, Wizcraft.wid("world/comet_warp_beacon_crown"));
    private static final int TINT_NEARBY = Color.ofHsv(0.0f, 0.0f, 1.0f, 0.5f).argb();
    private static final int TINT_REMOTE = Color.WHITE.argb();

    private static void drawBase(WorldRenderContext context, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        float rotation = ((float)context.world().method_8510() + context.tickCounter().method_60637(true)) / 20.0f;
        Matrix4f perPanelAdjustment = new Matrix4f().rotateAround((Quaternionfc)class_7833.field_40718.rotationDegrees(30.0f), 0.5f, 0.5f, 0.0f).translate(0.0f, 0.0f, -0.02f);
        CometWarpBeaconRenderer.drawBasePart(poseStack, buffer, packedLight, packedOverlay, rotation, class_7833.field_40718, -0.01f, perPanelAdjustment);
        CometWarpBeaconRenderer.drawBasePart(poseStack, buffer, packedLight, packedOverlay, rotation, class_7833.field_40717, -0.02f, perPanelAdjustment);
        poseStack.method_22909();
    }

    private static void drawBasePart(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float rotation, class_7833 rotationAxis, float initialOffset, Matrix4f perPanelAdjustment) {
        poseStack.method_22903();
        poseStack.method_34425(new Matrix4f().rotateAround((Quaternionfc)rotationAxis.rotation(rotation), 0.5f, 0.5f, 0.0f));
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0.0f, 1.0f, 0.0f, 1.0f, initialOffset, 0.0f, 0.5f, 0.0f, 0.5f);
        poseStack.method_34425(perPanelAdjustment);
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0.0f, 1.0f, 0.0f, 1.0f, initialOffset, 0.0f, 0.5f, 0.0f, 0.5f);
        poseStack.method_34425(perPanelAdjustment);
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0.0f, 1.0f, 0.0f, 1.0f, initialOffset, 0.0f, 0.5f, 0.0f, 0.5f);
        poseStack.method_22909();
    }

    public void afterEntities(WorldRenderContext context) {
        int nearbyRange;
        class_746 player = class_310.method_1551().field_1724;
        boolean inGoggles = player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES);
        class_1799 wandStack = player.method_6047();
        if (!wandStack.method_31573(WizcraftItemTags.WANDS)) {
            return;
        }
        class_4208 anchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        int n = nearbyRange = inGoggles ? Wizcraft.getConfig().cometWarpBeaconDisplayRange + Wizcraft.getConfig().trueseerGogglesDisplayRange : Wizcraft.getConfig().cometWarpBeaconDisplayRange;
        if (anchor == null || anchor.comp_2207() != context.world().method_27983() || !anchor.comp_2208().method_19769((class_2374)player.method_19538(), (double)nearbyRange) || !context.frustum().method_23093(class_238.method_29968((class_243)anchor.comp_2208().method_46558()))) {
            return;
        }
        class_4587 poseStack = context.matrixStack();
        int light = class_761.method_23794((class_1920)context.world(), (class_2338)anchor.comp_2208().method_10084());
        int overlay = class_4608.field_21444;
        poseStack.method_22903();
        class_243 translation = context.camera().method_19326().method_1035(class_243.method_24954((class_2382)anchor.comp_2208()));
        poseStack.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);
        class_4588 buffer = context.consumers().getBuffer(BASE_LAYER);
        CometWarpBeaconRenderer.drawBase(context, poseStack, buffer, light, overlay);
        poseStack.method_22903();
        Matrix4f adjustment = new Matrix4f().rotateAround((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f), 0.0f, 0.5f, 0.0f).translate(0.0f, 0.25f, -1.0f).scaleAround(0.5f, 0.5f, 0.5f, 0.5f);
        poseStack.method_34425(adjustment);
        Matrix4f perPanelAdjustment = new Matrix4f().rotateAround((Quaternionfc)class_7833.field_40716.rotationDegrees(60.0f), 0.5f, 0.0f, 0.5f);
        class_1058 sprite = CROWN_TEX.method_24148();
        class_4588 crownBuffer = CROWN_TEX.method_24145(context.consumers(), class_1921::method_42600);
        for (int i = 0; i < 6; ++i) {
            poseStack.method_34425(perPanelAdjustment);
            RenderingUtil.drawSprite(poseStack, crownBuffer, sprite, TINT_NEARBY, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, -0.365f);
        }
        poseStack.method_22909();
        poseStack.method_22909();
    }

    public void onEnd(WorldRenderContext context) {
        class_746 player = class_310.method_1551().field_1724;
        if (!player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            return;
        }
        class_1799 wandStack = player.method_6047();
        if (!wandStack.method_31573(WizcraftItemTags.WANDS)) {
            return;
        }
        class_4208 anchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        int remoteRange = Wizcraft.getConfig().trueseerGogglesDisplayRange * 16;
        if (anchor == null || anchor.comp_2207() != context.world().method_27983() || !anchor.comp_2208().method_19769((class_2374)player.method_19538(), (double)remoteRange) || !context.frustum().method_23093(class_238.method_29968((class_243)anchor.comp_2208().method_46558()))) {
            return;
        }
        class_4587 poseStack = context.matrixStack();
        int light = 0xF000F0;
        int overlay = class_4608.field_21444;
        poseStack.method_22903();
        class_243 translation = context.camera().method_19326().method_1035(class_243.method_24954((class_2382)anchor.comp_2208()));
        float scale = (float)(class_3532.method_15345((double)class_3532.method_15345((double)translation.method_1027())) / 4.0);
        poseStack.method_34425(new Matrix4f().translate((Vector3fc)translation.method_46409()).rotateAround((Quaternionfc)context.camera().method_23767(), 0.5f, 0.5f, 0.5f).scaleAround(scale, 0.5f, 0.5f, 0.5f));
        RenderingUtil.drawTexture(poseStack, context.consumers().getBuffer(REMOTE_LAYER), TINT_REMOTE, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        poseStack.method_22909();
    }
}

