/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common;

import com.google.common.base.Preconditions;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.config.WizcraftConfig;
import falseresync.wizcraft.common.data.ChargeShellsAttachment;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_5321;

public class ChargeManager {
    public static final Event<WandExpend> WAND_CHARGE_SPENT = EventFactory.createArrayBacked(WandExpend.class, listeners -> (wandStack, cost, user) -> {
        for (WandExpend listener : listeners) {
            listener.onWandChargeSpent(wandStack, cost, user);
        }
    });
    public static final Event<WandOvercharge> WAND_OVERCHARGED = EventFactory.createArrayBacked(WandOvercharge.class, listeners -> (wandStack, excess, user) -> {
        for (WandOvercharge listener : listeners) {
            listener.onWandOvercharged(wandStack, excess, user);
        }
    });

    public ChargeManager() {
        WAND_CHARGE_SPENT.register((wandStack, cost, user) -> {
            if (user != null) {
                ChargeShellsAttachment chargeShells = (ChargeShellsAttachment)user.getAttached(WizcraftAttachments.CHARGE_SHELLS);
                if (chargeShells == null) {
                    return;
                }
                Integer wandCurrent = (Integer)wandStack.method_57825(WizcraftComponents.WAND_CHARGE, (Object)0);
                Integer wandMax = (Integer)wandStack.method_57825(WizcraftComponents.WAND_MAX_CHARGE, (Object)0);
                int compensation = wandMax - wandCurrent;
                ChargeShellsAttachment newShells = chargeShells.withChargeChange(-compensation);
                if (newShells != null) {
                    user.setAttached(WizcraftAttachments.CHARGE_SHELLS, (Object)newShells);
                    wandStack.method_57368(WizcraftComponents.WAND_CHARGE, (Object)0, it -> it + compensation);
                }
            }
        });
        WAND_OVERCHARGED.register((wandStack, excess, user) -> {
            if (user != null) {
                Wizcraft.getChargeManager().applyShellCharge(user, excess);
            }
        });
    }

    public boolean areShellsFull(class_1657 player) {
        return player.hasAttached(WizcraftAttachments.CHARGE_SHELLS) && ((ChargeShellsAttachment)player.getAttached(WizcraftAttachments.CHARGE_SHELLS)).areShellsFull();
    }

    public void applyShellCharge(class_1657 player, int amount) {
        ChargeShellsAttachment shells = (ChargeShellsAttachment)player.getAttached(WizcraftAttachments.CHARGE_SHELLS);
        if (shells == null) {
            return;
        }
        ChargeShellsAttachment newShells = shells.withChargeChange(amount);
        if (newShells != null) {
            player.setAttached(WizcraftAttachments.CHARGE_SHELLS, (Object)newShells);
        }
    }

    public boolean isWandFullyCharged(class_1799 wandStack) {
        return (Integer)wandStack.method_57825(WizcraftComponents.WAND_CHARGE, (Object)0) >= (Integer)wandStack.method_57825(WizcraftComponents.WAND_MAX_CHARGE, (Object)0);
    }

    public boolean cannotAddAnyCharge(class_1799 wandStack, class_1657 player) {
        return this.isWandFullyCharged(wandStack) && this.areShellsFull(player);
    }

    public boolean tryExpendWandCharge(class_1799 wandStack, int cost, @Nullable class_1657 user) {
        if (user != null && (user.method_7337() && Wizcraft.getConfig().infiniteCharge.isCreativeOnly() || Wizcraft.getConfig().infiniteCharge.isAlways())) {
            return true;
        }
        Integer charge = (Integer)wandStack.method_57825(WizcraftComponents.WAND_CHARGE, (Object)0);
        if (charge >= cost) {
            wandStack.method_57368(WizcraftComponents.WAND_CHARGE, (Object)charge, current -> current - cost);
            ((WandExpend)WAND_CHARGE_SPENT.invoker()).onWandChargeSpent(wandStack, cost, user);
            return true;
        }
        return false;
    }

    public void chargeWand(class_1799 wandStack, int amount, @Nullable class_1657 user) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Use tryExpendCharge to subtract charge");
        Integer current = (Integer)wandStack.method_57825(WizcraftComponents.WAND_CHARGE, (Object)0);
        Integer max = (Integer)wandStack.method_57825(WizcraftComponents.WAND_MAX_CHARGE, (Object)0);
        wandStack.method_57368(WizcraftComponents.WAND_CHARGE, (Object)0, it -> Math.min(it + amount, max));
        if (current + amount > max) {
            ((WandOvercharge)WAND_OVERCHARGED.invoker()).onWandOvercharged(wandStack, current + amount - max, user);
        }
    }

    public void tryChargeWandPassively(class_1799 wandStack, class_1937 world, class_1657 player) {
        if (Wizcraft.getChargeManager().cannotAddAnyCharge(wandStack, player)) {
            return;
        }
        WizcraftConfig.PassiveCharge config = Wizcraft.getConfig().passiveCharge;
        if (config == WizcraftConfig.PassiveCharge.DISABLED) {
            return;
        }
        float usageCoefficient = class_1799.method_7973((class_1799)player.method_6047(), (class_1799)wandStack) ? 1.0f : 0.25f;
        float passiveChargingThreshold = Math.clamp(0.005f * this.calculateEnvironmentCoefficient(world, player) * config.coefficient * usageCoefficient, 0.0f, 0.1f);
        if (world.field_9229.method_43057() < passiveChargingThreshold) {
            Wizcraft.getChargeManager().chargeWand(wandStack, 1, player);
        }
    }

    public float calculateEnvironmentCoefficient(class_1937 world, class_1657 player) {
        float environmentCoefficient = 1.0f;
        class_5321 worldType = world.method_27983();
        if (worldType == class_1937.field_25180) {
            environmentCoefficient *= 0.1f;
        } else if (worldType == class_1937.field_25181) {
            environmentCoefficient *= 3.0f;
        } else {
            environmentCoefficient *= world.method_23886() ? 1.0f : 0.5f;
            environmentCoefficient *= ((class_1959)world.method_23753(player.method_24515()).comp_349()).method_48163() ? 1.0f - world.method_8430(1.0f) : 1.0f;
            environmentCoefficient *= (float)world.method_8314(class_1944.field_9284, player.method_24515()) / ((float)world.method_8315() * 0.5f);
        }
        return environmentCoefficient;
    }

    @FunctionalInterface
    public static interface WandExpend {
        public void onWandChargeSpent(class_1799 var1, int var2, @Nullable class_1657 var3);
    }

    @FunctionalInterface
    public static interface WandOvercharge {
        public void onWandOvercharged(class_1799 var1, int var2, @Nullable class_1657 var3);
    }
}

