/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.blockentity.LensingPedestalBlockEntity;
import falseresync.wizcraft.common.blockentity.WizcraftBlockEntities;
import falseresync.wizcraft.common.blockentity.WorktableBlockEntity;
import falseresync.wizcraft.common.recipe.LensedWorktableRecipe;
import falseresync.wizcraft.common.recipe.SimpleInventoryRecipeInput;
import falseresync.wizcraft.common.recipe.WizcraftRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class CraftingWorktableBlockEntity
extends WorktableBlockEntity {
    public static final int IDLE_SEARCH_COOLDOWN = 5;
    protected final List<LensingPedestalBlockEntity> pedestals = new ArrayList<LensingPedestalBlockEntity>();
    protected final List<class_2338> nonEmptyPedestalPositions = new ArrayList<class_2338>();
    protected final class_1277 inventory = new class_1277(this, 1){

        public int method_5444() {
            return 1;
        }
    };
    protected final InventoryStorage storage = InventoryStorage.of((class_1263)this.inventory, null);
    protected final SimpleInventoryRecipeInput virtualCombinedInventory = new SimpleInventoryRecipeInput(this, 5){

        public int method_5444() {
            return 1;
        }
    };
    protected int remainingIdleSearchCooldown = 0;
    protected int remainingCraftingTime = 0;
    protected int craftingTime = 0;
    protected class_1799 currentlyCrafted = class_1799.field_8037;
    @Nullable
    protected class_2960 currentRecipeId;
    @Nullable
    protected LensedWorktableRecipe currentRecipe;

    public CraftingWorktableBlockEntity(class_2338 pos, class_2680 state) {
        super(WizcraftBlockEntities.CRAFTING_WORKTABLE, pos, state);
        this.inventory.method_5489(sender -> this.method_5431());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CraftingWorktableBlockEntity worktable) {
        worktable.tick(world, pos, state);
    }

    @Override
    public void activate(@Nullable class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.searchPedestals(this.field_11863, this.field_11867);
        if (this.pedestals.size() < 4) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                player.method_17356(class_3417.field_14962, class_3419.field_15245, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43471((String)"hud.wizcraft.worktable.incomplete_worktable"), true);
            }
            return;
        }
        this.updateVirtualCombinedInventory();
        this.field_11863.method_8433().method_8132(WizcraftRecipes.LENSED_WORKTABLE, this.virtualCombinedInventory.recipeInput(), this.field_11863).ifPresent(this::beginCrafting);
    }

    @Override
    public void remove(class_1937 world, class_2338 pos) {
        this.searchPedestals(world, pos);
        this.pedestals.forEach(pedestal -> pedestal.linkTo(null));
    }

    public List<class_2338> getNonEmptyPedestalPositions() {
        return this.nonEmptyPedestalPositions;
    }

    public Progress getProgress() {
        return new Progress(this.currentlyCrafted, this.remainingCraftingTime, this.craftingTime - this.remainingCraftingTime, 1.0f - (float)this.remainingCraftingTime / (float)this.craftingTime);
    }

    public class_1799 getHeldStackCopy() {
        return this.inventory.method_5438(0).method_7972();
    }

    @Override
    public class_1277 getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryStorage getStorage() {
        return this.storage;
    }

    protected void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.currentRecipe == null && this.currentRecipeId != null) {
            this.updateVirtualCombinedInventory();
            world.method_8433().method_8130(this.currentRecipeId).flatMap(entry -> {
                Optional<Object> optional;
                class_1860 patt0$temp = entry.comp_1933();
                if (patt0$temp instanceof LensedWorktableRecipe) {
                    LensedWorktableRecipe recipe = (LensedWorktableRecipe)patt0$temp;
                    optional = Optional.of(recipe);
                } else {
                    optional = Optional.empty();
                }
                return optional;
            }).ifPresentOrElse(recipe -> this.initStaticRecipeData(world, (LensedWorktableRecipe)recipe), this::reset);
        }
        if (world.field_9236) {
            return;
        }
        if (this.currentRecipe != null) {
            this.tickCrafting(world, pos, this.currentRecipe);
            return;
        }
        this.tickIdle(world, pos);
    }

    protected void tickCrafting(class_1937 world, class_2338 pos, LensedWorktableRecipe recipe) {
        --this.remainingCraftingTime;
        this.searchPedestals(world, pos);
        this.method_5431();
        if (this.pedestals.size() < 4) {
            this.interruptCrafting();
            return;
        }
        this.updateVirtualCombinedInventory();
        if (!recipe.method_8115(this.virtualCombinedInventory.recipeInput(), world)) {
            this.interruptCrafting();
            return;
        }
        if (this.remainingCraftingTime <= 0) {
            this.finishCrafting();
            return;
        }
    }

    protected void tickIdle(class_1937 world, class_2338 pos) {
        if (this.remainingIdleSearchCooldown > 0) {
            --this.remainingIdleSearchCooldown;
            return;
        }
        this.remainingIdleSearchCooldown = 5;
        this.searchPedestals(world, pos);
    }

    protected void searchPedestals(class_1937 world, class_2338 pos) {
        this.pedestals.clear();
        for (class_2338 pedestalPos : List.of(pos.method_10076(2), pos.method_10088(2), pos.method_10077(2), pos.method_10089(2))) {
            class_2586 class_25862 = world.method_8321(pedestalPos);
            if (!(class_25862 instanceof LensingPedestalBlockEntity)) continue;
            LensingPedestalBlockEntity pedestal = (LensingPedestalBlockEntity)class_25862;
            if (!pedestal.isLinkedTo(this)) {
                world.method_22352(pos, true);
                world.method_8396(null, pos, class_3417.field_14890, class_3419.field_15245, 1.0f, 1.0f);
                continue;
            }
            this.pedestals.add(pedestal);
            pedestal.linkTo(this);
        }
    }

    protected void updateVirtualCombinedInventory() {
        this.virtualCombinedInventory.method_5447(0, this.inventory.method_5438(0).method_7972());
        for (int i = 0; i < this.pedestals.size(); ++i) {
            this.virtualCombinedInventory.method_5447(i + 1, this.pedestals.get(i).getHeldStackCopy());
        }
    }

    protected void beginCrafting(class_8786<LensedWorktableRecipe> recipeEntry) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.currentRecipeId = recipeEntry.comp_1932();
        this.initStaticRecipeData(this.field_11863, (LensedWorktableRecipe)recipeEntry.comp_1933());
        this.remainingCraftingTime = ((LensedWorktableRecipe)recipeEntry.comp_1933()).getCraftingTime();
        this.method_5431();
        this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_22452.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
    }

    protected void interruptCrafting() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.reset();
        CraftingWorktableBlockEntity.onInterrupted(this, this.field_11863, this.field_11867);
    }

    protected void finishCrafting() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.currentRecipe == null) {
            return;
        }
        this.inventory.method_5447(0, this.currentRecipe.method_8116(this.virtualCombinedInventory.recipeInput(), (class_7225.class_7874)this.field_11863.method_30349()));
        class_2371 remainders = this.currentRecipe.method_8111(this.virtualCombinedInventory.recipeInput());
        for (int i = 0; i < this.pedestals.size(); ++i) {
            this.pedestals.get(i).onCrafted((class_1799)remainders.get(i + 1));
        }
        this.reset();
        this.field_11863.method_8396(null, this.field_11867, WizcraftSounds.WORKTABLE_SUCCESS, class_3419.field_15245, 1.0f, 1.0f);
        class_2770 stopSoundPacket = new class_2770(((class_3414)class_3417.field_22452.comp_349()).method_14833(), class_3419.field_15245);
        for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
            player.field_13987.method_14364((class_2596)stopSoundPacket);
        }
    }

    protected void initStaticRecipeData(class_1937 world, LensedWorktableRecipe recipe) {
        this.currentRecipe = recipe;
        this.craftingTime = recipe.getCraftingTime();
        this.currentlyCrafted = this.currentRecipe.method_8116(this.virtualCombinedInventory.recipeInput(), (class_7225.class_7874)world.method_30349());
    }

    protected void reset() {
        this.virtualCombinedInventory.method_5448();
        this.currentRecipeId = null;
        this.currentRecipe = null;
        this.craftingTime = 0;
        this.currentlyCrafted = class_1799.field_8037;
        this.remainingCraftingTime = 0;
        this.remainingIdleSearchCooldown = 0;
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)registryLookup);
        if (!this.pedestals.isEmpty()) {
            class_2499 nbtList = this.pedestals.stream().filter(pedestal -> !pedestal.getHeldStackCopy().method_7960()).map(class_2586::method_11016).map(class_2512::method_10692).map(it -> {
                class_2487 tag = new class_2487();
                tag.method_10566("pedestal", it);
                return tag;
            }).collect(Collectors.toCollection(class_2499::new));
            nbt.method_10566("non_empty_pedestals", (class_2520)nbtList);
        } else {
            nbt.method_10551("non_empty_pedestals");
        }
        if (this.currentRecipeId != null) {
            nbt.method_10582("current_recipe", this.currentRecipeId.toString());
        } else {
            nbt.method_10551("current_recipe");
        }
        if (this.remainingCraftingTime != 0) {
            nbt.method_10569("remaining_crafting_time", this.remainingCraftingTime);
        } else {
            nbt.method_10551("remaining_crafting_time");
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_54454().clear();
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)registryLookup);
        this.nonEmptyPedestalPositions.clear();
        if (nbt.method_10573("non_empty_pedestals", 9)) {
            class_2499 nbtList = nbt.method_10554("non_empty_pedestals", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2512.method_10691((class_2487)nbtList.method_10602(i), (String)"pedestal").ifPresent(this.nonEmptyPedestalPositions::add);
            }
        }
        this.currentRecipeId = null;
        if (nbt.method_10573("current_recipe", 8)) {
            this.currentRecipeId = class_2960.method_12829((String)nbt.method_10558("current_recipe"));
        }
        this.remainingCraftingTime = 0;
        if (nbt.method_10573("remaining_crafting_time", 3)) {
            this.remainingCraftingTime = nbt.method_10550("remaining_crafting_time");
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public record Progress(class_1799 currentlyCrafted, int remainingCraftingTime, int passedCraftingTime, float value) {
    }
}

