/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.data;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ChargeShellsAttachment(int currentCharge, IntList shells, int maxCharge) {
    public static final int MAX_SHELLS = 3;
    public static final int MAX_CHARGE = 1000;
    public static final Codec<ChargeShellsAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("currentCharge").forGetter(ChargeShellsAttachment::currentCharge), (App)class_5699.field_33441.sizeLimitedListOf(3).xmap(it -> new IntImmutableList((Collection)it), it -> it).fieldOf("shells").forGetter(ChargeShellsAttachment::shells), (App)class_5699.method_48766((int)0, (int)1000).fieldOf("maxCharge").forGetter(ChargeShellsAttachment::maxCharge)).apply((Applicative)instance, ChargeShellsAttachment::new));
    public static final class_9139<class_9129, ChargeShellsAttachment> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, ChargeShellsAttachment::currentCharge, (class_9139)class_9135.method_57991(IntArrayList::new, (class_9139)class_9135.field_49675, (int)3), ChargeShellsAttachment::shells, (class_9139)class_9135.field_49675, ChargeShellsAttachment::maxCharge, ChargeShellsAttachment::new);

    public ChargeShellsAttachment {
        Preconditions.checkArgument((currentCharge >= 0 && currentCharge <= maxCharge ? 1 : 0) != 0, (Object)"Current charge must be between 0 and max charge");
        Preconditions.checkArgument((shells.size() < 3 ? 1 : 0) != 0, (Object)"There can only be %s shells".formatted(3));
        Preconditions.checkArgument((maxCharge < 1000 ? 1 : 0) != 0, (Object)"There can only be %s charge in all shells in total".formatted(1000));
        Preconditions.checkArgument((shells.intStream().sum() == maxCharge ? 1 : 0) != 0, (Object)"The max charge must be the same as the sum of shell charges");
    }

    public static ChargeShellsAttachment createDefault() {
        return new ChargeShellsAttachment(0, IntList.of(), 0);
    }

    @Nullable
    public ChargeShellsAttachment withShell(int shellCharge) {
        if (this.canAddShell(shellCharge)) {
            IntArrayList newList = new IntArrayList(this.shells);
            newList.add(shellCharge);
            return new ChargeShellsAttachment(this.currentCharge, (IntList)new IntImmutableList((IntList)newList), Math.min(newList.intStream().sum(), 1000));
        }
        return null;
    }

    public boolean canAddShell(int shellCharge) {
        return shellCharge > 0 && (this.maxCharge < 1000 || this.shells.size() < 3);
    }

    public boolean areShellsFull() {
        return this.currentCharge == this.maxCharge;
    }

    @Nullable
    public ChargeShellsAttachment withChargeChange(int chargeChange) {
        if (this.canChangeCharge(chargeChange)) {
            return new ChargeShellsAttachment(Math.clamp((long)(this.currentCharge + chargeChange), 0, this.maxCharge), this.shells, this.maxCharge);
        }
        return null;
    }

    public boolean canChangeCharge(int chargeChange) {
        return chargeChange < this.maxCharge && this.currentCharge + chargeChange >= 0;
    }
}

