/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import falseresync.wizcraft.common.data.EphemeralInventory;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ContainerComponent(ImmutableList<class_1799> stacks, int size) implements class_5632
{
    public static final Codec<ContainerComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Slot.CODEC.listOf().xmap(ContainerComponent::fromSlots, ContainerComponent::toSlots).fieldOf("slots").forGetter(ContainerComponent::stacks), (App)Codec.INT.fieldOf("size").forGetter(ContainerComponent::size)).apply((Applicative)instance, ContainerComponent::createRespectingSize));
    public static final class_9139<class_9129, ContainerComponent> PACKET_CODEC = class_9139.method_56435((class_9139)class_1799.field_49269, ContainerComponent::stacks, (class_9139)class_9135.field_49675, ContainerComponent::size, ContainerComponent::new);

    public ContainerComponent(List<class_1799> stacks, int size) {
        this((ImmutableList<class_1799>)ImmutableList.copyOf(stacks), size);
    }

    private static ContainerComponent createRespectingSize(List<class_1799> stacks, int size) {
        if (size > stacks.size()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(stacks);
            for (int i = stacks.size(); i < size; ++i) {
                builder.add((Object)class_1799.field_8037);
            }
            return new ContainerComponent((ImmutableList<class_1799>)builder.build(), size);
        }
        return new ContainerComponent(stacks, size);
    }

    public static ContainerComponent createDefault(int size) {
        return new ContainerComponent((List<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037), size);
    }

    public static List<class_1799> fromSlots(List<Slot> slots) {
        class_2371 stacks = class_2371.method_10213((int)(slots.stream().mapToInt(Slot::index).max().orElseThrow() + 1), (Object)class_1799.field_8037);
        for (Slot slot : slots) {
            stacks.set(slot.index, (Object)slot.stack);
        }
        return stacks;
    }

    public static List<Slot> toSlots(List<class_1799> stacks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = stacks.get(i);
            if (stack.method_7960()) continue;
            builder.add((Object)new Slot(i, stack));
        }
        return builder.build();
    }

    public int getSlotWithStack(class_1799 stack) {
        for (int i = 0; i < this.size(); ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.stacks.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public EphemeralInventory toModifiable() {
        return new EphemeralInventory(this);
    }

    @Override
    public String toString() {
        return "InventoryComponent" + String.valueOf(this.stacks);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ContainerComponent) {
            ContainerComponent that = (ContainerComponent)obj;
            return this.stacks.size() == that.stacks.size() && class_1799.method_57362(this.stacks, that.stacks);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return class_1799.method_57361(this.stacks);
    }

    public record Slot(int index, class_1799 stack) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("index").forGetter(Slot::index), (App)class_1799.field_24671.fieldOf("stack").forGetter(Slot::stack)).apply((Applicative)instance, Slot::new));
    }
}

