/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.entity;

import com.google.common.base.Preconditions;
import com.mojang.serialization.DynamicOps;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.entity.WizcraftEntities;
import falseresync.wizcraft.common.entity.WizcraftEntityTags;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4844;
import net.minecraft.class_7094;
import net.minecraft.class_8046;
import net.minecraft.class_8113;
import net.minecraft.class_8836;
import net.minecraft.class_9691;

public class EnergyVeilEntity
extends class_1297
implements class_8046 {
    public static final float SCREENS_OFFSET = 0.25f;
    public static final int MINIMAL_LIFE_EXPECTANCY = 20;
    private static final class_2940<Float> RADIUS = class_2945.method_12791(EnergyVeilEntity.class, (class_2941)class_2943.field_13320);
    public class_7094 slideAnimationState = new class_7094();
    private int lifeExpectancy;
    @Nullable
    private class_1657 owner;
    @Nullable
    private class_1799 controllingStack;

    public EnergyVeilEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public EnergyVeilEntity(@Nullable class_1657 owner, @Nullable class_1799 controllingStack, class_1937 world) {
        this(WizcraftEntities.ENERGY_VEIL, world);
        Preconditions.checkArgument((controllingStack == null || owner != null ? 1 : 0) != 0, (Object)"Owner must not be null if a controlling stack is present");
        Preconditions.checkArgument((controllingStack == null || controllingStack.method_31573(WizcraftItemTags.WANDS) ? 1 : 0) != 0, (Object)"A controlling stack must be a wand");
        this.owner = owner;
        this.controllingStack = controllingStack;
        this.field_6012 = 0;
        this.lifeExpectancy = 20;
        this.field_5960 = true;
        this.field_17046 = new class_243(1.0, 1.0, 1.0);
        this.method_5875(true);
        if (owner != null) {
            this.method_33574(owner.method_19538());
        }
        this.alignWithOwner();
    }

    public void incrementLifeExpectancy(int by) {
        this.lifeExpectancy += by;
    }

    public void alignWithOwner() {
        if (this.owner == null) {
            return;
        }
        this.method_18799(this.owner.method_19538().method_1020(this.method_19538()));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(RADIUS, (Object)Float.valueOf(1.0f));
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (RADIUS.equals(data)) {
            this.method_5857(this.method_33332());
        }
        if (this.owner != null) {
            this.owner.setAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID, (Object)this.method_5628());
        }
        if (this.method_5770().method_8608()) {
            this.slideAnimationState.method_41324(this.field_6012);
        }
    }

    public void method_5773() {
        super.method_5773();
        this.alignWithOwner();
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (!this.method_37908().field_9236) {
            this.repelOutsiders();
            if (this.field_6012 >= this.lifeExpectancy) {
                if (this.owner != null) {
                    this.owner.removeAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID);
                    if (this.controllingStack != null) {
                        this.controllingStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                    }
                }
                this.method_31472();
            }
        }
    }

    private void repelOutsiders() {
        List entities = this.method_37908().method_8333((class_1297)this, this.method_5829(), class_1301.field_6155.and(it -> !it.equals((Object)this.owner)).and(it -> !this.isOwnedByOwner((class_1297)it)).and(it -> !it.method_5864().method_20210(WizcraftEntityTags.PASSES_THROUGH_ENERGY_VEIL)).and(it -> {
            class_8836 vehicle;
            return !(it instanceof class_8836 && !(vehicle = (class_8836)it).method_5782());
        }).and(it -> !(it instanceof class_8113) && !(it instanceof class_9691)).and(it -> !this.isComingFromAboveOrBelow((class_1297)it)).and(it -> !this.isInside((class_1297)it)));
        for (class_1297 entity : entities) {
            if (!this.isOnTheEdge(entity)) continue;
            class_243 entityToOwner = entity.method_19538().method_1035(this.method_19538());
            class_243 velocity = entity.method_60478();
            if (!(velocity.method_1026(entityToOwner) >= 0.0)) continue;
            if (velocity.method_1027() >= 0.75 || entity instanceof class_1676) {
                entity.method_18799(velocity.method_22882().method_1021(0.5));
                entity.field_6007 = true;
            } else if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6005(1.0, entityToOwner.field_1352, entityToOwner.field_1350);
            } else {
                entity.method_5784(class_1313.field_6310, entityToOwner.method_22882().method_1021(3.0));
            }
            entity.field_6037 = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOwnedByOwner(class_1297 entity) {
        if (!(entity instanceof class_8046)) return false;
        class_8046 ownable = (class_8046)entity;
        if (this.owner == null) return false;
        if (!this.owner.equals((Object)ownable.method_24921())) return false;
        return true;
    }

    private boolean isComingFromAboveOrBelow(class_1297 entity) {
        return entity.method_23318() > this.method_23318() + (double)this.getVeilVisibleRadius() + 0.25 || entity.method_23320() < this.method_23318() - 0.25;
    }

    private boolean isInside(class_1297 entity) {
        return entity.method_19538().method_1025(this.method_19538()) <= Math.pow(this.getVeilVisibleRadius(), 2.0);
    }

    private boolean isOnTheEdge(class_1297 entity) {
        return entity.method_19538().method_1025(this.method_19538()) <= Math.pow(this.getRadius(), 2.0);
    }

    public boolean method_5696() {
        return true;
    }

    public final float getRadius() {
        return ((Float)this.field_6011.method_12789(RADIUS)).floatValue();
    }

    public final void setRadius(float radius) {
        Preconditions.checkArgument((radius >= 2.0f && radius <= 4.0f ? 1 : 0) != 0, (Object)"Veil radius cannot be smaller than 2 or greater than 4");
        this.field_6011.method_12778(RADIUS, (Object)Float.valueOf(radius));
    }

    public final float getVeilVisibleRadius() {
        return this.getRadius() - 0.25f;
    }

    @Nullable
    public class_1657 getOwner() {
        return this.owner;
    }

    public int getLifeExpectancy() {
        return this.lifeExpectancy;
    }

    private class_4048 getDimensions() {
        return class_4048.method_18384((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.getDimensions();
    }

    protected class_238 method_33332() {
        return this.getDimensions().method_30757(this.method_19538());
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10573("radius", 5)) {
            this.setRadius(nbt.method_10583("radius"));
        }
        if (nbt.method_10573("age", 3)) {
            this.field_6012 = nbt.method_10550("age");
        }
        if (nbt.method_10573("life_expectancy", 3)) {
            this.lifeExpectancy = nbt.method_10550("life_expectancy");
        }
        if (nbt.method_10545("owner")) {
            class_4844.field_25122.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("owner")).resultOrPartial(class_156.method_29188((String)"Could not decode a Player UUID of ", Wizcraft.LOGGER::error)).ifPresent(pair -> {
                this.owner = this.method_5770().method_18470(this.field_6021);
            });
            if (this.owner != null && nbt.method_10545("controlling_stack")) {
                this.controllingStack = this.owner.method_31548().method_5438(nbt.method_10550("controlling_stack"));
                if (this.controllingStack.method_7960()) {
                    this.controllingStack = null;
                }
            }
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("radius", this.getRadius());
        nbt.method_10569("age", this.field_6012);
        nbt.method_10569("life_expectancy", this.getLifeExpectancy());
        if (this.owner != null) {
            class_4844.field_25122.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.owner.method_5667()).ifSuccess(it -> nbt.method_10566("owner", it));
            if (this.controllingStack != null) {
                int slot = this.owner.method_31548().method_7395(this.controllingStack);
                if (slot >= 0) {
                    nbt.method_10569("controlling_stack", slot);
                } else {
                    this.controllingStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                }
            }
        }
    }
}

