/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.focus.FocusItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_4550;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6538;
import net.minecraft.class_9334;

public class CometWarpFocusItem
extends FocusItem {
    public static final class_6538 LODESTONE_CHECKER = new class_6538(List.of(class_4550.class_4710.method_23880().method_27962(new class_2248[]{class_2246.field_23261}).method_23882()), false);
    public static final int DEFAULT_PLACEMENT_COST = 5;
    public static final int DEFAULT_WARPING_COST = 15;
    public static final int DEFAULT_INTERDIMENSIONAL_COST = 30;
    public static final int PERSISTENT_ANCHOR_COST_COEFFICIENT = 2;

    public CometWarpFocusItem(class_1792.class_1793 settings) {
        super(settings.method_57349(class_9334.field_49634, (Object)LODESTONE_CHECKER));
    }

    private static void reportPermanentlyBound(class_1657 player, class_4208 permanentAnchor) {
        player.method_7353((class_2561)class_2561.method_43469((String)"hud.wizcraft.focus.comet_warp.permanently_anchored", (Object[])new Object[]{permanentAnchor.comp_2207().method_29177().method_12832(), permanentAnchor.comp_2208().method_23854()}), true);
    }

    private static void appendTooltip$internal(class_1799 wandStack, class_1799 focusStack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type, boolean showSetupTip) {
        class_4208 persistentAnchor;
        if (focusStack.method_57826(WizcraftComponents.TOOLTIP_OVERRIDDEN)) {
            return;
        }
        class_4208 anchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        if (anchor != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.wizcraft.wand.has_anchor", (Object[])new Object[]{anchor.comp_2207().method_29177().method_12832(), anchor.comp_2208().method_23854()}).method_27692(class_124.field_1080));
        }
        if ((persistentAnchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR)) != null) {
            String key = focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE) ? "tooltip.wizcraft.wand.has_anchor" : "tooltip.wizcraft.wand.has_permanent_anchor";
            tooltip.add((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{persistentAnchor.comp_2207().method_29177().method_12832(), persistentAnchor.comp_2208().method_23854()}).method_27692(class_124.field_1080));
        }
        if (anchor == null && persistentAnchor == null && showSetupTip) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.wizcraft.wand.setup_anchor").method_27692(class_124.field_1080));
        }
    }

    @Override
    public void focusOnEquipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        this.transferComponent(focusStack, wandStack, WizcraftComponents.WARP_FOCUS_ANCHOR);
        this.transferComponent(focusStack, wandStack, WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    @Override
    public void focusOnUnequipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        this.transferComponent(wandStack, focusStack, WizcraftComponents.WARP_FOCUS_ANCHOR);
        this.transferComponent(wandStack, focusStack, WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    @Override
    public class_1269 focusUseOn(class_1799 wandStack, class_1799 focusStack, class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_4208 persistentAnchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
        if (persistentAnchor != null && !focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
            if (world.field_9236 && player.method_5715()) {
                CometWarpFocusItem.reportPermanentlyBound(player, persistentAnchor);
            }
            return class_1269.field_5811;
        }
        class_2338 pos = context.method_8037();
        if (focusStack.method_57357(new class_2694((class_4538)world, pos, false))) {
            if (!world.field_9236 && player.method_5715()) {
                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, 10, player)) {
                    Reports.insufficientCharge(player);
                    return class_1269.field_5814;
                }
                player.method_17356(class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                wandStack.method_57379(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR, (Object)class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos.method_10084()));
                wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                focusStack.method_7970(1, (class_1309)player, class_1304.field_6173);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
            if (world.field_9236) {
                player.method_7353((class_2561)class_2561.method_43471((String)"hud.wizcraft.focus.comet_warp.cannot_anchor_here"), true);
            }
            return class_1269.field_5814;
        }
        return super.focusUseOn(wandStack, focusStack, context);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (user.method_5715()) {
                    class_4208 persistentAnchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                    if (persistentAnchor != null) {
                        if (!focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
                            CometWarpFocusItem.reportPermanentlyBound((class_1657)player, persistentAnchor);
                        }
                        return class_1271.method_22431((Object)wandStack);
                    }
                    if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, 5, user)) {
                        Reports.insufficientCharge((class_1657)player);
                        return class_1271.method_22431((Object)wandStack);
                    }
                    Reports.playSoundToEveryone((class_1657)player, WizcraftSounds.COMET_WARP_ANCHOR_PLACED);
                    wandStack.method_57379(WizcraftComponents.WARP_FOCUS_ANCHOR, (Object)class_4208.method_19443((class_5321)world.method_27983(), (class_2338)user.method_24515()));
                    if (world.field_9229.method_43057() < 0.1f) {
                        focusStack.method_7970(1, (class_1309)player, class_1304.field_6173);
                    }
                } else {
                    int warpingCost;
                    class_4208 anchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
                    boolean persistent = false;
                    if (anchor == null) {
                        anchor = (class_4208)wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                        persistent = true;
                    }
                    if (anchor == null) {
                        player.method_17356(class_3417.field_14962, class_3419.field_15248, 1.0f, 1.0f);
                        player.method_7353((class_2561)class_2561.method_43471((String)"hud.wizcraft.focus.comet_warp.no_anchor"), true);
                        return class_1271.method_22431((Object)wandStack);
                    }
                    class_3218 destination = serverWorld.method_8503().method_3847(anchor.comp_2207());
                    if (destination == null) {
                        player.method_17356(class_3417.field_15239, class_3419.field_15248, 1.0f, 1.0f);
                        wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                        wandStack.method_57381(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                        return class_1271.method_22431((Object)wandStack);
                    }
                    int n = warpingCost = destination.method_8597() != world.method_8597() ? 30 : 15;
                    if (persistent) {
                        warpingCost /= 2;
                    }
                    if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, warpingCost, user)) {
                        Reports.insufficientCharge((class_1657)player);
                        return class_1271.method_22431((Object)wandStack);
                    }
                    Reports.playSoundToEveryone((class_1657)player, class_3417.field_46945);
                    user.method_5731(new class_5454(destination, anchor.comp_2208().method_46558(), class_243.field_1353, user.method_36454(), user.method_36455(), class_5454.field_52245));
                    if (!persistent) {
                        wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                    }
                    focusStack.method_7970(1, (class_1309)player, class_1304.field_6173);
                }
                return class_1271.method_22427((Object)wandStack);
            }
        }
        return class_1271.method_22428((Object)wandStack);
    }

    @Override
    public boolean focusIsFoil(class_1799 wandStack, class_1799 focusStack) {
        return this.method_7886(wandStack);
    }

    @Override
    public void focusAppendHoverText(class_1799 wandStack, class_1799 focusStack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        CometWarpFocusItem.appendTooltip$internal(wandStack, focusStack, context, tooltip, type, true);
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_57826(WizcraftComponents.WARP_FOCUS_ANCHOR) || stack.method_57826(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        CometWarpFocusItem.appendTooltip$internal(stack, stack, context, tooltip, type, false);
    }
}

