/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.data.ItemBarComponent;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.entity.EnergyVeilEntity;
import falseresync.wizcraft.common.item.focus.FocusItem;
import falseresync.wizcraft.common.world.WizcraftWorld;
import io.wispforest.owo.ui.core.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5253;
import net.minecraft.class_5362;
import net.minecraft.class_7923;

public class EnergyVeilFocusItem
extends FocusItem {
    public static final int USE_DURATION = 200;
    public static final int STARTING_COST = 10;
    public static final int CONTINUOUS_COST = 2;
    private static final int CYAN_ARGB = class_5253.class_5254.method_27764((int)0, (int)115, (int)190, (int)211);
    private static final Color CYAN = Color.ofArgb((int)CYAN_ARGB);
    private static final Color RED = Color.ofHsv((float)0.0055555557f, (float)1.0f, (float)0.8f);

    public EnergyVeilFocusItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public void focusOnEquipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        this.removeOrphanedVeilReference(wandStack, user);
    }

    @Override
    public void focusOnUnequipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        this.resetWand(wandStack);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1657 user, class_1268 hand) {
        this.removeOrphanedVeilReference(wandStack, user);
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (!wandStack.method_57826(WizcraftComponents.ENERGY_VEIL_UUID) && !user.hasAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID)) {
                if (Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, 10, user)) {
                    EnergyVeilEntity veil = new EnergyVeilEntity(user, wandStack, level);
                    veil.setRadius(2.0f);
                    level.method_8649((class_1297)veil);
                    wandStack.method_57379(WizcraftComponents.ENERGY_VEIL_UUID, (Object)veil.method_5667());
                    wandStack.method_57379(WizcraftComponents.IN_USE, (Object)true);
                    user.method_6019(user.method_6058());
                    return class_1271.method_22427((Object)wandStack);
                }
                Reports.insufficientCharge((class_1657)player);
                return class_1271.method_22431((Object)wandStack);
            }
        }
        return class_1271.method_22430((Object)wandStack);
    }

    @Override
    public void focusOnUseTick(class_1937 level, class_1309 user, class_1799 wandStack, class_1799 focusStack, int remainingUseTicks) {
        this.findVeil(wandStack, level).ifPresent(veil -> {
            if (user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, 2, (class_1657)player)) {
                    player.method_5643(level.method_48963().method_48831(), 0.1f);
                    Integer previousDeficit = (Integer)wandStack.method_57368(WizcraftComponents.CHARGE_DEFICIT, (Object)0, it -> it + 2);
                    if (previousDeficit != null && previousDeficit % 70 == 0) {
                        class_1299.field_6059.method_47821((class_3218)level, WizcraftUtil.fuzzyPos(level.field_9229, 1, player.method_24515()), class_3730.field_16461);
                    }
                    if (level.field_9229.method_43057() < 0.1f) {
                        focusStack.method_7970(1, user, class_1304.field_6173);
                    }
                }
                veil.incrementLifeExpectancy(2);
                int maxUseTicks = this.focusGetUseDuration(wandStack, focusStack, user);
                wandStack.method_57379(WizcraftComponents.ITEM_BAR, (Object)new ItemBarComponent(Math.clamp((long)Math.round((float)(maxUseTicks - remainingUseTicks) * 13.0f / (float)maxUseTicks), 0, 13), CYAN_ARGB));
                if (level.field_9229.method_43057() < 0.01f) {
                    focusStack.method_7970(1, user, class_1304.field_6173);
                }
            }
        });
    }

    @Override
    public void focusReleaseUsing(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.focusFinishUsingItem(wandStack, focusStack, world, user);
    }

    @Override
    public class_1799 focusFinishUsingItem(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1309 user) {
        if (!level.field_9236) {
            Optional.ofNullable((Integer)wandStack.method_57824(WizcraftComponents.CHARGE_DEFICIT)).ifPresent(deficit -> {
                if (deficit > 100) {
                    level.method_8454((class_1297)user, level.method_48963().method_48831(), (class_5362)WizcraftWorld.MagicDischargeExplosionBehavior.INSTANCE, user.method_23317(), user.method_23318(), user.method_23321(), 3.0f, false, class_1937.class_7867.field_51779, (class_2394)class_2398.field_29644, (class_2394)class_2398.field_11221, class_7923.field_41172.method_47983((Object)WizcraftSounds.STAR_PROJECTILE_EXPLODE));
                }
            });
            this.resetWand(wandStack);
            focusStack.method_7970(1, user, class_1304.field_6173);
        }
        return wandStack;
    }

    @Override
    public int focusGetUseDuration(class_1799 wandStack, class_1799 focusStack, class_1309 user) {
        return 200;
    }

    @Override
    public void focusInventoryTick(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        if (wandStack.method_57826(WizcraftComponents.IN_USE)) {
            return;
        }
        this.findVeil(wandStack, level).ifPresent(veil -> {
            float delta = Math.clamp(2.0f * (float)(veil.getLifeExpectancy() - veil.field_6012) / (float)veil.getLifeExpectancy(), 0.0f, 1.0f);
            if (delta <= 0.07692308f) {
                wandStack.method_57381(WizcraftComponents.ITEM_BAR);
            } else {
                wandStack.method_57379(WizcraftComponents.ITEM_BAR, (Object)new ItemBarComponent(Math.clamp((long)Math.round(delta * 13.0f), 0, 13), RED.interpolate(CYAN, delta).argb()));
            }
        });
    }

    private void resetWand(class_1799 wandStack) {
        wandStack.method_57381(WizcraftComponents.IN_USE);
        wandStack.method_57381(WizcraftComponents.ITEM_BAR);
        wandStack.method_57381(WizcraftComponents.CHARGE_DEFICIT);
    }

    private Optional<EnergyVeilEntity> findVeil(class_1799 wandStack, class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return Optional.ofNullable((UUID)wandStack.method_57824(WizcraftComponents.ENERGY_VEIL_UUID)).flatMap(uuid -> {
                class_1297 patt0$temp = serverLevel.method_14190(uuid);
                if (patt0$temp instanceof EnergyVeilEntity) {
                    EnergyVeilEntity veil = (EnergyVeilEntity)patt0$temp;
                    return Optional.of(veil);
                }
                return Optional.empty();
            });
        }
        return Optional.empty();
    }

    private void removeOrphanedVeilReference(class_1799 wandStack, class_1657 user) {
        class_1937 class_19372 = user.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            Optional.ofNullable((UUID)wandStack.method_57824(WizcraftComponents.ENERGY_VEIL_UUID)).ifPresent(uuid -> {
                if (!(serverLevel.method_14190(uuid) instanceof EnergyVeilEntity)) {
                    wandStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                    user.removeAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID);
                }
            });
        }
    }
}

