/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import falseresync.wizcraft.common.recipe.WizcraftRecipeSerializers;
import falseresync.wizcraft.common.recipe.WizcraftRecipes;
import java.util.ArrayDeque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public final class LensedWorktableRecipe
implements class_1860<class_9695> {
    private final class_1799 result;
    private final int craftingTime;
    private final class_1856 worktableInput;
    private final class_2371<class_1856> pedestalInputs;
    private final class_2371<class_1856> allIngredients;

    public LensedWorktableRecipe(class_1799 result, class_1856 worktableInput, class_2371<class_1856> pedestalInputs) {
        this(result, 100, worktableInput, pedestalInputs);
    }

    public LensedWorktableRecipe(class_1799 result, int craftingTime, class_1856 worktableInput, class_2371<class_1856> pedestalInputs) {
        this.result = result;
        this.craftingTime = craftingTime;
        this.worktableInput = worktableInput;
        this.pedestalInputs = pedestalInputs;
        this.allIngredients = class_2371.method_37434((int)(pedestalInputs.size() + 1));
        this.allIngredients.add((Object)worktableInput);
        this.allIngredients.addAll(pedestalInputs);
    }

    public class_2371<class_1856> method_8117() {
        return this.allIngredients;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_8115(class_9695 input, class_1937 world) {
        if (input.method_59983() < this.allIngredients.size()) {
            return false;
        }
        if (!this.worktableInput.method_8093(input.method_59984(0))) {
            return false;
        }
        ArrayDeque stacksInSlots = IntStream.rangeClosed(1, input.method_59983()).mapToObj(arg_0 -> ((class_9695)input).method_59984(arg_0)).filter(stack -> !stack.method_7960()).collect(Collectors.toCollection(ArrayDeque::new));
        for (int i = 0; i < stacksInSlots.size(); ++i) {
            boolean stacksMatchPedestals = true;
            for (class_1856 pedestalInput : this.pedestalInputs) {
                class_1799 currentStack = (class_1799)stacksInSlots.removeFirst();
                stacksInSlots.offerLast(currentStack);
                if (pedestalInput.method_8093(currentStack)) continue;
                stacksMatchPedestals = false;
                break;
            }
            if (!stacksMatchPedestals) continue;
            return true;
        }
        return false;
    }

    public class_1799 method_8116(class_9695 input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.allIngredients.size();
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.result.method_7972();
    }

    public class_1865<LensedWorktableRecipe> method_8119() {
        return WizcraftRecipeSerializers.LENSED_WORKTABLE;
    }

    public class_3956<LensedWorktableRecipe> method_17716() {
        return WizcraftRecipes.LENSED_WORKTABLE;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public class_1856 getWorktableInput() {
        return this.worktableInput;
    }

    public class_2371<class_1856> getPedestalInputs() {
        return this.pedestalInputs;
    }

    public static class Serializer
    implements class_1865<LensedWorktableRecipe> {
        public static final MapCodec<LensedWorktableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("crafting_time", (Object)100).flatXmap(craftingTime -> craftingTime < 30 ? DataResult.error(() -> "Crafting time below 30 ticks is unsupported") : DataResult.success((Object)craftingTime), DataResult::success).forGetter(recipe -> recipe.craftingTime), (App)class_1856.field_46096.fieldOf("worktable").forGetter(recipe -> recipe.worktableInput), (App)class_1856.field_46096.listOf().fieldOf("pedestals").flatXmap(ingredients -> {
            Object[] nonEmptyIngredients = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (nonEmptyIngredients.length == 0) {
                return DataResult.error(() -> "No pedestal ingredients for a Lensed worktable recipe");
            }
            return nonEmptyIngredients.length > 4 ? DataResult.error(() -> "Too many pedestal ingredients for a Lensed worktable recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])nonEmptyIngredients));
        }, DataResult::success).forGetter(recipe -> recipe.pedestalInputs)).apply((Applicative)instance, LensedWorktableRecipe::new));
        public static final class_9139<class_9129, LensedWorktableRecipe> PACKET_CODEC = class_9139.method_56905((class_9139)class_1799.field_48349, recipe -> recipe.result, (class_9139)class_9135.field_49675, recipe -> recipe.craftingTime, (class_9139)class_1856.field_48355, recipe -> recipe.worktableInput, (class_9139)class_9135.method_56376(class_2371::method_37434, (class_9139)class_1856.field_48355), recipe -> recipe.pedestalInputs, LensedWorktableRecipe::new);

        public MapCodec<LensedWorktableRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, LensedWorktableRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

