/*
 * Decompiled with CFR 0.152.
 */
package falseresync.wizcraft.compat.lavender;

import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.recipe.CountableIngredient;
import falseresync.wizcraft.common.recipe.CrucibleRecipe;
import falseresync.wizcraft.common.recipe.WizcraftRecipes;
import falseresync.wizcraft.compat.lavender.CountableItemListComponent;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.md.features.RecipeFeature;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WizcraftLavenderPlugin {
    public static final class_2960 CRUCIBLE_TEX = Wizcraft.wid("textures/gui/recipe/crucible.png");
    public static final class_2960 ARROW_TEX = Wizcraft.wid("textures/gui/recipe/arrow_right.png");
    public static final class_2960 GRIMOIRE_ID = Wizcraft.wid("grimoire");

    public static void init() {
        UIParsing.registerFactory((class_2960)Wizcraft.wid("countable-item-list"), element -> new CountableItemListComponent());
        final Map<String, String> params = Map.of("arrow-tex", ARROW_TEX.toString(), "crucible-tex", CRUCIBLE_TEX.toString());
        LavenderBookScreen.registerRecipePreviewBuilder((class_2960)GRIMOIRE_ID, WizcraftRecipes.CRUCIBLE, (RecipeFeature.RecipePreviewBuilder)new RecipeFeature.RecipePreviewBuilder<CrucibleRecipe>(){

            @NotNull
            public Component buildRecipePreview(BookCompiler.ComponentSource componentSource, class_8786<CrucibleRecipe> recipeEntry) {
                CrucibleRecipe recipe = (CrucibleRecipe)recipeEntry.comp_1933();
                ParentComponent recipeComponent = (ParentComponent)componentSource.template(UIModelLoader.get((class_2960)GRIMOIRE_ID), ParentComponent.class, "crucible-recipe", params);
                this.populateCountableIngredientsRemoveUnused((List<class_1856>)recipe.ingredients(), (ParentComponent)recipeComponent.childById(ParentComponent.class, "ingredients"));
                ((ItemComponent)recipeComponent.childById(ItemComponent.class, "result")).stack(recipe.result());
                return recipeComponent;
            }

            private void populateCountableIngredientsRemoveUnused(List<class_1856> ingredients, ParentComponent componentContainer) {
                List items = componentContainer.children().stream().flatMap(it -> {
                    Stream<Object> stream;
                    if (it instanceof CountableItemListComponent) {
                        CountableItemListComponent entry = (CountableItemListComponent)((Object)it);
                        stream = Stream.of(entry);
                    } else {
                        stream = Stream.empty();
                    }
                    return stream;
                }).toList();
                for (int i = 0; i < ingredients.size(); ++i) {
                    class_1856 ingredient = ingredients.get(i);
                    CustomIngredient customIngredient = ingredient.getCustomIngredient();
                    if (customIngredient instanceof CountableIngredient) {
                        CountableIngredient countableIngredient = (CountableIngredient)customIngredient;
                        ((CountableItemListComponent)((Object)items.get(i))).countableIngredient(countableIngredient);
                        continue;
                    }
                    ((CountableItemListComponent)((Object)items.get(i))).ingredient(ingredient);
                }
                if (items.size() - ingredients.size() > 0) {
                    int last = items.size();
                    for (int i = ingredients.size(); i < last; ++i) {
                        componentContainer.removeChild((Component)items.get(i));
                    }
                }
            }
        });
    }
}

