package dev.zenfyr.pulsar.client.fakeworld;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Lifecycle;
import dev.zenfyr.pulsar.client.events.AfterFirstReload;
import dev.zenfyr.pulsar.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.experimental.UtilityClass;
import net.minecraft.class_1267;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2535;
import net.minecraft.class_2598;
import net.minecraft.class_310;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7723;
import net.minecraft.class_7756;
import net.minecraft.class_7780;
import net.minecraft.class_7782;
import net.minecraft.class_7887;
import net.minecraft.class_7924;
import net.minecraft.core.*;

@UtilityClass
public class FakeWorld {

  public static final ThreadLocal<Boolean> LOADING = ThreadLocal.withInitial(() -> false);

  public static final Supplier<class_638> INSTANCE = Suppliers.memoize(() -> {
    try {
      LOADING.set(true);
      var regs = FakeWorld.getRegistries();

      class_634 networkHandler = new class_634(
          class_310.method_1551(),
          null,
          new class_2535(class_2598.field_11942),
          null,
          new GameProfile(UUID.randomUUID(), "fake_profile_ratio"),
          null);
      networkHandler.field_25063 = class_7756.method_45738()
          .method_45930(
              class_7756.field_40491,
              new class_5455.class_6891(
                      class_7782.method_47449(regs))
                  .method_40316());

      return new class_638(
          networkHandler,
          new class_638.class_5271(class_1267.field_5805, false, false),
          class_1937.field_25179,
          regs.method_45935(class_7659.field_39973)
              .method_30530(class_7924.field_41241)
              .method_40290(class_7134.field_37666),
          0,
          0,
          null,
          class_310.method_1551().field_1769,
          true,
          0);
    } finally {
      LOADING.remove();
    }
  });

  private static class_7780<class_7659> getRegistries() {
    class_7780<class_7659> combinedDynamicRegistries =
        class_7659.method_45139();
    class_7780<class_7659> cdr2 = bootstrapBuiltin(combinedDynamicRegistries);

    class_5455.class_6890 immutable = cdr2.method_45935(class_7659.field_39973);

    class_7723 preset = class_5317.method_41598(immutable);
    class_7723.class_7725 dimensionsConfig =
        preset.method_45518(new class_2370<>(class_7924.field_41224, Lifecycle.stable()));

    return cdr2.method_45930(class_7659.field_39973, dimensionsConfig.method_45537());
  }

  private static class_7780<class_7659> bootstrapBuiltin(
      class_7780<class_7659> cdr) {
    class_7225.class_7874 pain = class_7887.method_46817();

    List<? extends class_5321<? extends class_2378<?>>> keys =
        class_7655.field_39968.stream()
            .map(class_7655.class_7657::comp_985)
            .toList();

    List<class_2370<Object>> regs = new ArrayList<>(keys.size());
    for (class_5321<? extends class_2378<?>> key : keys) {
      class_2370<Object> registry =
          new class_2370<>(Utilities.cast(key), Lifecycle.stable());

      pain.method_46759(key).ifPresent(impl -> impl.method_42017()
          .forEach(ref -> registry.method_10272(ref.method_40237(), ref.comp_349(), Lifecycle.stable())));

      registry.method_40276();
      regs.add(registry);
    }
    class_5455.class_6890 immutable1 =
        new class_5455.class_6891(ImmutableList.copyOf(regs)).method_40316();
    return cdr.method_45930(class_7659.field_39972, immutable1);
  }

  public static void init() {
    AfterFirstReload.EVENT.register(INSTANCE::get);
  }
}
