package dev.zenfyr.pulsar.client.particles;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

@Environment(EnvType.CLIENT)
public abstract class AbstractScreenParticle implements class_4068 {
  public double x, y, velX, velY;
  public double prevX, prevY;
  public int age = 0, deathAge = 200;
  protected class_310 client;
  public boolean removed = false;
  protected class_437 screen;

  public AbstractScreenParticle(double x, double y, double velX, double velY) {
    this.x = x;
    this.y = y;
    this.velX = velX;
    this.velY = velY;
    this.prevX = x - velX;
    this.prevY = y - velY;
    this.client = class_310.method_1551();
  }

  @Override
  @ApiStatus.OverrideOnly
  public abstract void method_25394(class_332 context, int mouseX, int mouseY, float delta);

  @ApiStatus.OverrideOnly
  protected abstract void tick();

  @ApiStatus.OverrideOnly
  protected boolean checkRemoval() {
    return age >= deathAge;
  }

  public void bindToScreen(class_437 screen) {
    this.screen = screen;
  }

  @ApiStatus.Internal
  public final void renderInternal(class_332 context, int mouseX, int mouseY, float delta) {
    if (removed || (screen != null && client.field_1755 != screen)) return;
    method_25394(context, mouseX, mouseY, delta);
  }

  @ApiStatus.Internal
  public final void tickInternal() {
    this.prevX = x;
    this.prevY = y;

    tick();
    age++;
    this.removed = checkRemoval();
    if (screen != null && client.field_1755 != screen) removed = true;
  }
}
