package dev.zenfyr.pulsar.client.particles;

import dev.zenfyr.pulsar.util.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;

@Environment(EnvType.CLIENT)
public class ItemStackParticle extends AbstractScreenParticle {

  public final class_1799 stack;

  public ItemStackParticle(double x, double y, double velX, double velY, class_1799 stack) {
    super(x, y, velX, velY);
    this.stack = stack;
  }

  @Override
  public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
    class_4587 matrices = context.method_51448();
    float x = (float) class_3532.method_16436(delta, this.prevX, this.x);
    float y = (float) class_3532.method_16436(delta, this.prevY, this.y);
    matrices.method_22903();
    matrices.method_46416(x, y, 500);
    float angle = (float) Math.toDegrees(Math.atan2(velY, velX) * 0.5);
    matrices.method_22907(class_7833.field_40718.rotationDegrees(angle));
    context.method_51427(stack, -8, -8);
    matrices.method_22909();
  }

  @Override
  protected void tick() {
    x += velX *= 0.99;
    y += velY * 0.99;
    velY += MathUtil.nextDouble(0.4, 0.9);
  }

  @Override
  protected boolean checkRemoval() {
    int w = client.method_22683().method_4486();
    int h = client.method_22683().method_4486();
    return ((x > w + 80) || (x < -80)) || ((y > h + 80) || (y < -80));
  }
}
