package dev.zenfyr.pulsar.client.particles;

import dev.zenfyr.pulsar.util.MakeSure;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import lombok.experimental.UtilityClass;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_703;
import org.jetbrains.annotations.ApiStatus;

@UtilityClass
@SuppressWarnings("unused")
@Environment(EnvType.CLIENT)
public final class ScreenParticleHelper {

  private static final Set<AbstractScreenParticle> SCREEN_PARTICLES = new LinkedHashSet<>();
  private static final Set<AbstractScreenParticle> SCREEN_PARTICLES_REMOVAL = new HashSet<>();

  public static void addParticle(AbstractScreenParticle particle) {
    ScreenParticleHelper.addScreenParticle(null, particle);
  }

  public static void addParticle(
      class_2394 parameters, double x, double y, double velX, double velY) {
    ScreenParticleHelper.addScreenParticle(null, parameters, x, y, velX, velY);
  }

  public static void addParticle(
      class_2394 parameters, double x, double y, double velX, double velY, double velZ) {
    ScreenParticleHelper.addScreenParticle(null, parameters, x, y, velX, velY, velZ);
  }

  public static void addParticles(AbstractScreenParticle... particle) {
    ScreenParticleHelper.addScreenParticles(null, particle);
  }

  public static void addParticles(List<AbstractScreenParticle> particle) {
    ScreenParticleHelper.addScreenParticles(null, particle);
  }

  public static void addParticles(Supplier<AbstractScreenParticle> particle, int count) {
    ScreenParticleHelper.addScreenParticles(null, particle, count);
  }

  public static void addParticles(
      class_2394 parameters,
      double x,
      double y,
      double deltaX,
      double deltaY,
      double speed,
      int count) {
    ScreenParticleHelper.addScreenParticles(null, parameters, x, y, deltaX, deltaY, speed, count);
  }

  /////////////////////////////

  public static void addScreenParticle(AbstractScreenParticle particle) {
    ScreenParticleHelper.addScreenParticle(current(), particle);
  }

  public static void addScreenParticle(
      class_2394 parameters, double x, double y, double velX, double velY) {
    ScreenParticleHelper.addScreenParticle(current(), parameters, x, y, velX, velY);
  }

  public static void addScreenParticle(
      class_2394 parameters, double x, double y, double velX, double velY, double velZ) {
    ScreenParticleHelper.addScreenParticle(current(), parameters, x, y, velX, velY, velZ);
  }

  public static void addScreenParticles(AbstractScreenParticle... particles) {
    ScreenParticleHelper.addScreenParticles(current(), particles);
  }

  public static void addScreenParticles(List<AbstractScreenParticle> particles) {
    ScreenParticleHelper.addScreenParticles(current(), particles);
  }

  public static void addScreenParticles(Supplier<AbstractScreenParticle> particle, int count) {
    ScreenParticleHelper.addScreenParticles(current(), particle, count);
  }

  public static void addScreenParticles(
      class_2394 parameters,
      double x,
      double y,
      double deltaX,
      double deltaY,
      double speed,
      int count) {
    ScreenParticleHelper.addScreenParticles(
        current(), parameters, x, y, deltaX, deltaY, speed, count);
  }

  /////////////////////////////

  public static void addScreenParticle(class_437 screen, AbstractScreenParticle particle) {
    particle.bindToScreen(screen);
    SCREEN_PARTICLES.add(particle);
  }

  public static void addScreenParticle(
      class_437 screen, class_2394 parameters, double x, double y, double velX, double velY) {
    VanillaParticle particle = new VanillaParticle(parameters, x, y, velX, velY);
    particle.bindToScreen(screen);
    SCREEN_PARTICLES.add(particle);
  }

  public static void addScreenParticle(
      class_437 screen,
      class_2394 parameters,
      double x,
      double y,
      double velX,
      double velY,
      double velZ) {
    VanillaParticle particle = new VanillaParticle(parameters, x, y, velX, velY, velZ);
    particle.bindToScreen(screen);
    SCREEN_PARTICLES.add(particle);
  }

  public static void addScreenParticles(class_437 screen, AbstractScreenParticle... particles) {
    for (AbstractScreenParticle particle : particles) {
      particle.bindToScreen(screen);
    }
    SCREEN_PARTICLES.addAll(List.of(particles));
  }

  public static void addScreenParticles(class_437 screen, List<AbstractScreenParticle> particles) {
    for (AbstractScreenParticle abstractScreenParticle : particles) {
      abstractScreenParticle.bindToScreen(screen);
    }
    SCREEN_PARTICLES.addAll(particles);
  }

  public static void addScreenParticles(
      class_437 screen, Supplier<AbstractScreenParticle> particle, int count) {
    for (int i = 0; i < count; i++) {
      AbstractScreenParticle particle1 = particle.get();
      particle1.bindToScreen(screen);
      SCREEN_PARTICLES.add(particle1);
    }
  }

  public static void addScreenParticles(
      class_437 screen,
      class_2394 parameters,
      double x,
      double y,
      double deltaX,
      double deltaY,
      double speed,
      int count) {
    MakeSure.isTrue(count >= 0, "Count can't be below 0!");

    for (int i = 0; i < count; i++) {
      double offsetX = random().nextGaussian() * deltaX;
      double offsetY = random().nextGaussian() * deltaY;
      double velX = random().nextGaussian() * speed;
      double velY = random().nextGaussian() * speed;

      VanillaParticle particle =
          new VanillaParticle(parameters, x + offsetX, y + offsetY, velX, velY);
      particle.bindToScreen(screen);
      SCREEN_PARTICLES.add(particle);
    }
  }

  /////////////////////////////

  public static AbstractScreenParticle ofVanilla(class_703 particle) {
    return new VanillaParticle(particle);
  }

  public static Supplier<AbstractScreenParticle> ofVanilla(Supplier<class_703> supplier) {
    return () -> new VanillaParticle(supplier.get());
  }

  private static class_437 current() {
    return class_310.method_1551().field_1755;
  }

  private static ThreadLocalRandom random() {
    return ThreadLocalRandom.current();
  }

  @ApiStatus.Internal
  public static void renderParticles(class_310 client, class_332 context) {
    if (SCREEN_PARTICLES.isEmpty()) return;

    int i = (int) (client.field_1729.method_1603()
        * (double) client.method_22683().method_4486()
        / (double) client.method_22683().method_4480());
    int j = (int) (client.field_1729.method_1604()
        * (double) client.method_22683().method_4502()
        / (double) client.method_22683().method_4507());
    for (AbstractScreenParticle particle : SCREEN_PARTICLES) {
      particle.renderInternal(context, i, j, client.method_1488());
    }
  }

  @ApiStatus.Internal
  public static void tickParticles() {
    if (SCREEN_PARTICLES.isEmpty()) return;

    for (AbstractScreenParticle particle : SCREEN_PARTICLES) {
      particle.tickInternal();
      if (particle.removed) SCREEN_PARTICLES_REMOVAL.add(particle);
    }

    SCREEN_PARTICLES.removeIf(SCREEN_PARTICLES_REMOVAL::contains);
    SCREEN_PARTICLES_REMOVAL.clear();
  }
}
