package dev.zenfyr.pulsar.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.zenfyr.pulsar.client.fakeworld.AlwaysBrightLightmapTextureManager;
import dev.zenfyr.pulsar.client.fakeworld.FakeWorld;
import dev.zenfyr.pulsar.impl.mixin.client.particles.ParticleManagerAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2394;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_757;

/**
 * Render vanilla particle types on screen!
 * <p>
 * Inspired by the removed {@code gesundheit} module of <a href="https://git.sleeping.town/unascribed-mods/Lib39">Lib39</a>
 */
@Environment(EnvType.CLIENT)
public class VanillaParticle extends AbstractScreenParticle {

  public static final ThreadLocal<class_638> WORLD = ThreadLocal.withInitial(() -> null);
  private static final class_4184 CAMERA = new class_4184();
  private final class_703 particle;

  public VanillaParticle(
      class_2394 parameters, double x, double y, double velX, double velY, double velZ) {
    super(0, 0, 0, 0);

    this.particle = createScreenParticle(parameters, x, y, velX, velY, velZ);
    if (this.particle != null) {
      this.particle.field_3862 = false;
    } else {
      this.removed = true;
    }
  }

  public VanillaParticle(class_2394 parameters, double x, double y, double velX, double velY) {
    this(parameters, x, y, velX, velY, 0);
  }

  public VanillaParticle(class_703 particle) {
    super(0, 0, 0, 0);

    this.particle = particle;
    if (this.particle != null) {
      this.particle.field_3862 = false;
    } else {
      this.removed = true;
    }
  }

  @Override
  protected void tick() {
    particle.method_3070();
  }

  @Override
  public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
    class_4587 matrices = context.method_51448();
    RenderSystem.disableCull();
    RenderSystem.enableDepthTest();

    matrices.method_22903();
    class_4587 matrixStack = RenderSystem.getModelViewStack();
    matrixStack.method_22903();
    matrixStack.method_46416(0, 0, 500);
    matrixStack.method_22905(24, 24, 1);
    matrixStack.method_46416(0, client.method_22683().method_4502() / 24f, 0);
    matrixStack.method_22905(1, -1, 1);
    matrixStack.method_34425(matrices.method_23760().method_23761());
    RenderSystem.applyModelViewMatrix();

    AlwaysBrightLightmapTextureManager.INSTANCE.method_3316();
    class_289 tessellator = class_289.method_1348();
    class_287 bufferBuilder = tessellator.method_1349();

    RenderSystem.setShader(class_757::method_34546);
    RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
    particle.method_18122().method_18130(bufferBuilder, client.method_1531());

    try {
      particle.method_3074(bufferBuilder, CAMERA, client.method_1488());
    } catch (Throwable var17) {
      class_128 crashReport =
          class_128.method_560(var17, "[Pulsar] Rendering Particle On Screen");
      class_129 crashReportSection =
          crashReport.method_562("Particle being rendered on screen");
      crashReportSection.method_577("Particle", particle::toString);
      crashReportSection.method_577("Particle Type", particle.method_18122()::toString);
      throw new class_148(crashReport);
    }

    particle.method_18122().method_18131(tessellator);

    AlwaysBrightLightmapTextureManager.INSTANCE.method_3315();
    matrixStack.method_22909();
    RenderSystem.applyModelViewMatrix();
    matrices.method_22909();

    RenderSystem.depthMask(true);
    RenderSystem.enableCull();
    RenderSystem.disableBlend();
  }

  @Override
  protected boolean checkRemoval() {
    return !particle.method_3086();
  }

  public static <T extends class_2394> class_703 createScreenParticle(
      T parameters, double x, double y, double velocityX, double velocityY, double velocityZ) {
    class_703 particle;
    try {
      WORLD.set(FakeWorld.INSTANCE.get());
      particle = ((ParticleManagerAccessor) class_310.method_1551().field_1713)
          .pulsar$createParticle(
              parameters,
              x / 24,
              (class_310.method_1551().method_22683().method_4502() - y) / 24,
              0,
              velocityX,
              velocityY,
              velocityZ);
    } finally {
      WORLD.remove();
    }
    return particle;
  }
}
