package dev.zenfyr.pulsar.codec;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class JsonCodecDataLoader<T> extends class_4309
    implements IdentifiableResourceReloadListener {

  @Contract("_, _, _ -> new")
  public static <T> @NotNull JsonCodecDataLoader<T> simple(
      class_2960 identifier, Codec<T> codec, BiConsumer<class_2960, T> consumer) {
    return new JsonCodecDataLoader<T>(identifier, codec) {
      @Override
      protected void apply(Map<class_2960, T> parsed, class_3300 manager) {
        parsed.forEach(consumer);
      }
    };
  }

  private final class_2960 identifier;
  private final Codec<T> codec;

  public JsonCodecDataLoader(class_2960 identifier, Codec<T> codec) {
    super(new Gson(), identifier.toString().replace(':', '/'));
    this.identifier = identifier;
    this.codec = codec;
  }

  @Override
  public final class_2960 getFabricId() {
    return this.identifier;
  }

  @Override
  protected void apply(
      Map<class_2960, JsonElement> prepared,
      class_3300 manager,
      class_3695 profiler) {
    this.apply(
        Maps.transformValues(
            prepared,
            input -> this.codec.parse(JsonOps.INSTANCE, input).getOrThrow(false, string -> {
              throw new JsonParseException(string);
            })),
        manager);
  }

  protected abstract void apply(Map<class_2960, T> parsed, class_3300 manager);
}
