package dev.zenfyr.pulsar.impl.mixin.resources;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.zenfyr.pulsar.resources.ReloaderType;
import dev.zenfyr.pulsar.resources.impl.InternalContentsAccessor;
import dev.zenfyr.pulsar.resources.impl.InternalContext;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7699;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value = class_5350.class, priority = 1100)
abstract class DataPackContentsMixin implements InternalContentsAccessor {

  @Unique private final Map<class_2960, IdentifiableResourceReloadListener> reloadersByIdentifier =
      new HashMap<>();

  @Unique private final IdentityHashMap<ReloaderType<?>, IdentifiableResourceReloadListener>
      reloadersByType = new IdentityHashMap<>();

  @Override
  public <T extends class_3302> T pulsar$getReloader(ReloaderType<T> type) {
    var reloader = this.reloadersByType.get(type);
    if (reloader == null) {
      synchronized (this.reloadersByIdentifier) {
        reloader = this.reloadersByIdentifier.get(type.identifier());
        if (reloader == null)
          throw new NoSuchElementException("Missing reloader %s".formatted(type.identifier()));
        this.reloadersByType.put(type, reloader);
      }
    }
    return (T) reloader;
  }

  @Override
  public void pulsar$setReloaders(List<IdentifiableResourceReloadListener> reloaders) {
    this.reloadersByIdentifier.clear();
    this.reloadersByType.clear();

    for (IdentifiableResourceReloadListener reloader : reloaders) {
      this.reloadersByIdentifier.put(reloader.getFabricId(), reloader);
    }
  }

  @WrapOperation(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/server/packs/resources/SimpleReloadInstance;create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;"),
      method = "loadResources")
  private static class_4011 setContext(
      class_3300 manager,
      List<class_3302> reloaders,
      Executor prepareExecutor,
      Executor applyExecutor,
      CompletableFuture<class_3902> initialStage,
      boolean profiled,
      Operation<class_4011> original,
      @Local class_5350 contents,
      @Local(argsOnly = true) class_5455.class_6890 registryManager,
      @Local(argsOnly = true) class_7699 featureSet) {
    try {
      InternalContext.LOCAL.set(new InternalContext(registryManager, featureSet, contents));
      return original.call(
          manager, reloaders, prepareExecutor, applyExecutor, initialStage, profiled);
    } finally {
      InternalContext.LOCAL.remove();
    }
  }
}
