package dev.zenfyr.pulsar.itemgroup;

import dev.zenfyr.pulsar.itemgroup.impl.ItemGroupExtensions;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_332;

@FunctionalInterface
@Environment(EnvType.CLIENT)
public interface ItemGroupAnimaton {

  static class_1761 setIconAnimation(class_1761 group, ItemGroupAnimaton animation) {
    ((ItemGroupExtensions) group).pulsar$setIconAnimation(animation);
    return group;
  }

  static Optional<ItemGroupAnimaton> getIconAnimation(class_1761 group) {
    return Optional.ofNullable(((ItemGroupExtensions) group).pulsar$getIconAnimation());
  }

  /**
   * Animates the icon for your item group.
   *
   * <p>This can draw anything you want</p>
   *
   * @param context the matrix stack used to render the screen
   * @param itemX the x-coordinate of the icon
   * @param itemY the y-coordinate of the icon
   */
  void animateIcon(
      class_1761 group,
      class_332 context,
      int itemX,
      int itemY,
      boolean selected,
      boolean isTopRow);
}
