package dev.zenfyr.pulsar.itemgroup;

import dev.zenfyr.pulsar.util.Utilities;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.NonNull;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface ItemGroupBuilder {

  static ItemGroupBuilder create(@NonNull class_2960 identifier) {
    return new ItemGroupBuilderImpl(identifier);
  }

  default ItemGroupBuilder icon(class_1799 itemStack) {
    return this.icon(() -> itemStack);
  }

  default ItemGroupBuilder icon(class_1935 item) {
    return this.icon(new class_1799(item));
  }

  ItemGroupBuilder icon(Supplier<class_1799> itemStackSupplier);

  ItemGroupBuilder texture(String texture);

  ItemGroupBuilder entries(PulsarEntries.Collector collector);

  ItemGroupBuilder displayName(class_2561 displayName);

  ItemGroupBuilder register(BooleanSupplier booleanSupplier);

  default ItemGroupBuilder register(boolean bool) {
    return register(bool ? Utilities.getTruth() : Utilities.getFalse());
  }

  class_2960 getId();

  @Nullable class_1761 build();

  default Optional<class_1761> optional() {
    return Optional.ofNullable(build());
  }
}
