package dev.zenfyr.pulsar.itemgroup;

import dev.zenfyr.pulsar.util.Utilities;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.NonNull;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

class ItemGroupBuilderImpl implements ItemGroupBuilder {

  private final class_2960 identifier;
  private Supplier<class_1799> icon = () -> class_1799.field_8037;
  private String texture;
  private PulsarEntries.Collector entries;
  private BooleanSupplier register = Utilities.getTruth();
  private class_2561 displayName;

  public ItemGroupBuilderImpl(class_2960 identifier) {
    this.identifier = identifier;
  }

  @Override
  public ItemGroupBuilder icon(@NonNull Supplier<class_1799> itemStackSupplier) {
    this.icon = itemStackSupplier;
    return this;
  }

  @Override
  public ItemGroupBuilder texture(@NonNull String texture) {
    this.texture = texture;
    return this;
  }

  @Override
  public ItemGroupBuilder entries(@NonNull PulsarEntries.Collector collector) {
    this.entries = collector;
    return this;
  }

  @Override
  public ItemGroupBuilder displayName(@NonNull class_2561 displayName) {
    this.displayName = displayName;
    return this;
  }

  @Override
  public ItemGroupBuilder register(@NonNull BooleanSupplier booleanSupplier) {
    this.register = booleanSupplier;
    return this;
  }

  @Override
  public class_2960 getId() {
    return this.identifier;
  }

  @Override
  public class_1761 build() {
    if (!this.register.getAsBoolean()) return null;

    class_1761.class_7913 builder = new class_1761.class_7913(null, -1);
    builder.method_47317((displayContext, operatorEnabled) -> {});
    builder.method_47320(() -> ItemGroupBuilderImpl.this.icon.get());

    builder.method_47321(Objects.requireNonNullElseGet(
        this.displayName,
        () -> class_2561.method_43471("itemGroup." + this.identifier.toString().replace(':', '.'))));
    if (this.texture != null) builder.method_47319(this.texture);
    builder.method_47317(
        (displayContext, entries1) -> this.entries.collect(new PulsarEntriesImpl(entries1)));

    class_1761 group = builder.method_47324();
    class_2378.method_10230(class_7923.field_44687, this.identifier, group);
    return group;
  }
}
