package dev.zenfyr.pulsar.itemgroup;

import dev.zenfyr.pulsar.util.MathUtil;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public interface PulsarEntries {
  void add(class_1799 stack, Visibility visibility);

  default void add(class_1799 stack) {
    this.add(stack, Visibility.TAB_AND_SEARCH);
  }

  default void add(class_1935 item, Visibility visibility) {
    this.add(new class_1799(item), visibility);
  }

  default void add(class_1935 item) {
    this.add(new class_1799(item), Visibility.TAB_AND_SEARCH);
  }

  default void addAll(@NotNull Collection<class_1799> stacks, Visibility visibility) {
    stacks.forEach(stack -> this.add(stack, visibility));
  }

  default void addAll(Collection<class_1799> stacks) {
    this.addAll(stacks, Visibility.TAB_AND_SEARCH);
  }

  default void appendStacks(Collection<class_1799> list) {
    appendStacks(list, true);
  }

  default void appendStacks(Collection<class_1799> list, boolean lineBreak) {
    if (list == null || list.isEmpty())
      return; // we shouldn't add line breaks if there are no items.

    int rows = MathUtil.fastCeil(list.size() / 9d);
    this.addAll(list, Visibility.TAB);
    int left = (rows * 9) - list.size();
    for (int i = 0; i < left; i++) {
      this.add(class_1799.field_8037, Visibility.TAB); // fill the gaps
    }
    if (lineBreak)
      this.addAll(class_2371.method_10213(9, class_1799.field_8037), Visibility.TAB); // line break
  }

  enum Visibility {
    TAB_AND_SEARCH,
    TAB,
    SEARCH;
  }

  interface Collector {
    void collect(PulsarEntries entries);
  }
}
