package dev.zenfyr.pulsar.itemstack;

import dev.zenfyr.pulsar.util.MathUtil;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import lombok.experimental.UtilityClass;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

@UtilityClass
@SuppressWarnings("unused")
public class ItemStackUtil {

  public static class_1799 getStackOrEmpty(class_1935 item) {
    return Optional.ofNullable(item)
        .map(class_1935::method_8389)
        .map(class_1792::method_7854)
        .orElse(class_1799.field_8037);
  }

  public static void spawn(@NonNull class_2338 pos, @NonNull class_1799 stack, @NonNull class_1937 world) {
    class_1542 itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void spawn(@NonNull class_243 pos, @NonNull class_1799 stack, @NonNull class_1937 world) {
    class_1542 itemEntity = new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack);
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void spawnVelocity(
      @NonNull class_2338 pos,
      @NonNull class_1799 stack,
      @NonNull class_1937 world,
      double minX,
      double maxX,
      double minY,
      double maxY,
      double minZ,
      double maxZ) {
    class_1542 itemEntity = new class_1542(
        world,
        pos.method_10263(),
        pos.method_10264(),
        pos.method_10260(),
        stack,
        MathUtil.nextDouble(minX, maxX),
        MathUtil.nextDouble(minY, maxY),
        MathUtil.nextDouble(minZ, maxZ));
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void spawnVelocity(
      @NonNull class_243 pos,
      @NonNull class_1799 stack,
      @NonNull class_1937 world,
      double minX,
      double maxX,
      double minY,
      double maxY,
      double minZ,
      double maxZ) {
    class_1542 itemEntity = new class_1542(
        world,
        pos.method_10216(),
        pos.method_10214(),
        pos.method_10215(),
        stack,
        MathUtil.nextDouble(minX, maxX),
        MathUtil.nextDouble(minY, maxY),
        MathUtil.nextDouble(minZ, maxZ));
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void spawnVelocity(
      @NotNull class_2338 pos, @NonNull class_1799 stack, @NonNull class_1937 world, @NotNull class_243 vec3d) {
    class_1542 itemEntity =
        new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void spawnVelocity(
      @NotNull class_243 pos, @NonNull class_1799 stack, @NonNull class_1937 world, @NotNull class_243 vec3d) {
    class_1542 itemEntity =
        new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    itemEntity.method_6988();
    world.method_8649(itemEntity);
  }

  public static void appendStacks(Collection<class_1799> stacks, Collection<class_1799> list) {
    appendStacks(stacks, list, true);
  }

  public static void appendStacks(
      Collection<class_1799> stacks, Collection<class_1799> list, boolean lineBreak) {
    if (list == null || list.isEmpty())
      return; // we shouldn't add line breaks if there are no items.

    int rows = MathUtil.fastCeil(list.size() / 9d);
    stacks.addAll(list);
    int left = (rows * 9) - list.size();
    for (int i = 0; i < left; i++) {
      stacks.add(class_1799.field_8037); // fill the gaps
    }
    if (lineBreak) stacks.addAll(class_2371.method_10213(9, class_1799.field_8037)); // line break
  }
}
