package dev.zenfyr.pulsar.nbt;

import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

class NbtBuilderImpl implements NbtBuilder {

  private final class_2487 nbt;

  public NbtBuilderImpl(class_2487 nbt) {
    if (nbt == null) nbt = new class_2487();
    this.nbt = nbt;
  }

  public NbtBuilderImpl() {
    this.nbt = new class_2487();
  }

  public NbtBuilder put(String key, @NonNull class_2520 element) {
    nbt.method_10566(key, element);
    return this;
  }

  @Override
  public NbtBuilder put(String key, @NonNull NbtBuilder builder) {
    nbt.method_10566(key, builder.build());
    return null;
  }

  public NbtBuilder putByte(String key, byte value) {
    nbt.method_10567(key, value);
    return this;
  }

  public NbtBuilder putShort(String key, short value) {
    nbt.method_10575(key, value);
    return this;
  }

  public NbtBuilder putInt(String key, int value) {
    nbt.method_10569(key, value);
    return this;
  }

  public NbtBuilder putLong(String key, long value) {
    nbt.method_10544(key, value);
    return this;
  }

  public NbtBuilder putUuid(String key, @NonNull UUID uuid) {
    nbt.method_25927(key, uuid);
    return this;
  }

  public NbtBuilder putFloat(String key, float value) {
    nbt.method_10548(key, value);
    return this;
  }

  public NbtBuilder putDouble(String key, double value) {
    nbt.method_10549(key, value);
    return this;
  }

  public NbtBuilder putString(String key, @NonNull String string) {
    nbt.method_10582(key, string);
    return this;
  }

  public NbtBuilder putByteArray(String key, byte @NonNull [] bytes) {
    nbt.method_10570(key, bytes);
    return this;
  }

  public NbtBuilder putByteArray(String key, @NonNull List<Byte> bytes) {
    nbt.method_36110(key, bytes);
    return this;
  }

  public NbtBuilder putIntArray(String key, int @NonNull [] ints) {
    nbt.method_10539(key, ints);
    return this;
  }

  public NbtBuilder putIntArray(String key, @NonNull List<Integer> ints) {
    nbt.method_10572(key, ints);
    return this;
  }

  public NbtBuilder putLongArray(String key, long @NonNull [] longs) {
    nbt.method_10564(key, longs);
    return this;
  }

  public NbtBuilder putLongArray(String key, @NonNull List<Long> longs) {
    nbt.method_10538(key, longs);
    return this;
  }

  public NbtBuilder putBoolean(String key, boolean value) {
    nbt.method_10556(key, value);
    return this;
  }

  @Override
  public String toString() {
    return "NbtBuilder{" + "nbt=" + nbt + '}';
  }

  public class_2487 build() {
    return nbt;
  }
}
