package dev.zenfyr.pulsar.nbt;

import lombok.experimental.UtilityClass;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@UtilityClass
@SuppressWarnings("unused")
public class NbtUtil {

  public static @NotNull class_2487 writeInventoryToNbt(
      class_2487 nbt, @NotNull class_1263 inventory) {
    return writeInventoryToNbt("Items", nbt, inventory);
  }

  /**
   * Writes items in an inventory to NbtCompound.
   *
   * @param nbt       the NbtCompound to write the inventory to
   * @param inventory the inventory to write to the NbtCompound
   * @return the NbtCompound with the inventory data written to it
   */
  public static @NotNull class_2487 writeInventoryToNbt(
      String key, class_2487 nbt, @NotNull class_1263 inventory) {
    nbt = (nbt == null) ? new class_2487() : nbt;
    class_2499 nbtList = new class_2499();
    for (int i = 0; i < inventory.method_5439(); ++i) {
      class_1799 itemStack = inventory.method_5438(i);
      if (!itemStack.method_7960()) {
        nbtList.add(itemStack.method_7953(NbtBuilder.create().putByte("Slot", (byte) i).build()));
      }
    }
    nbt.method_10566(key, nbtList);
    return nbt;
  }

  public static void readInventoryFromNbt(class_2487 nbt, class_1263 inventory) {
    readInventoryFromNbt("Items", nbt, inventory);
  }

  /**
   * Reads items in an inventory from a NbtCompound.
   *
   * @param nbt       the NbtCompound to read the inventory from
   * @param inventory the inventory to read the data into
   */
  public static void readInventoryFromNbt(String key, class_2487 nbt, class_1263 inventory) {
    if (nbt == null) return;
    if (!nbt.method_10545(key)) return;

    class_2499 nbtList = nbt.method_10554(key, class_2520.field_33260);
    for (int i = 0; i < nbtList.size(); ++i) {
      class_2487 nbtCompound = nbtList.method_10602(i);
      int j = nbtCompound.method_10571("Slot") & 255;
      //noinspection ConstantConditions
      if (j >= 0 && j < inventory.method_5439()) {
        inventory.method_5447(j, class_1799.method_7915(nbtCompound));
      }
    }
  }

  @Contract("null, _, _ -> param3")
  public static int getInt(class_2487 nbt, String name, int defaultValue) {
    if (nbt == null || !nbt.method_10545(name)) return defaultValue;
    return nbt.method_10550(name);
  }

  @Contract("null, _, _ -> param3")
  public static float getFloat(class_2487 nbt, String name, float defaultValue) {
    if (nbt == null || !nbt.method_10545(name)) return defaultValue;
    return nbt.method_10583(name);
  }

  @Contract("null, _, _ -> param3")
  public static double getDouble(class_2487 nbt, String name, double defaultValue) {
    if (nbt == null || !nbt.method_10545(name)) return defaultValue;
    return nbt.method_10574(name);
  }

  @Contract("null, _, _ -> param3")
  public static byte getByte(class_2487 nbt, String name, byte defaultValue) {
    if (nbt == null || !nbt.method_10545(name)) return defaultValue;
    return nbt.method_10571(name);
  }

  @Contract("null, _, _ -> param3")
  public static String getString(class_2487 nbt, String name, String defaultValue) {
    if (nbt == null || !nbt.method_10545(name)) return defaultValue;
    return nbt.method_10558(name);
  }

  @Deprecated
  @Contract("null, _, _, _ -> param3")
  public static int getInt(class_2487 nbt, String name, int min, int max) {
    if (nbt == null || !nbt.method_10545(name)) return min;
    int i = nbt.method_10550(name);
    return class_3532.method_15340(i, min, max);
  }

  @Deprecated
  @Contract("null, _, _, _ -> param3")
  public static float getFloat(class_2487 nbt, String name, float min, float max) {
    if (nbt == null || !nbt.method_10545(name)) return min;
    float i = nbt.method_10583(name);
    return class_3532.method_15363(i, min, max);
  }

  @Deprecated
  @Contract("null, _, _, _ -> param3")
  public static double getDouble(class_2487 nbt, String name, double min, double max) {
    if (nbt == null || !nbt.method_10545(name)) return min;
    double i = nbt.method_10574(name);
    return class_3532.method_15350(i, min, max);
  }

  @Deprecated
  @Contract("null, _, _, _ -> param3")
  public static float getByte(class_2487 nbt, String name, byte min, byte max) {
    if (nbt == null || !nbt.method_10545(name)) return min;
    byte i = nbt.method_10571(name);
    return class_3532.method_15340(i, min, max);
  }
}
