package dev.zenfyr.pulsar.registry;

import com.google.common.base.Suppliers;
import dev.zenfyr.pulsar.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.experimental.UtilityClass;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UtilityClass
@SuppressWarnings("unused")
public class RegistryUtil {

  private static final Map<class_2248, class_2591<?>> BLOCK_ENTITY_LOOKUP =
      Utilities.supply(new HashMap<>(), map -> {
        class_7923.field_41181.forEach(beType -> {
          for (class_2248 block : beType.field_19315) {
            map.putIfAbsent(block, beType);
          }
        });
      });

  @Contract("null -> null")
  public <T extends class_2586> class_2591<T> asBlockEntity(@Nullable class_2248 block) {
    if (block == null) return null;

    var r = BLOCK_ENTITY_LOOKUP.get(block);
    if (r != null) return Utilities.cast(r);

    class_7923.field_41181.forEach(beType -> {
      for (class_2248 block1 : beType.field_19315) {
        BLOCK_ENTITY_LOOKUP.putIfAbsent(block1, beType);
      }
    });
    return Utilities.cast(BLOCK_ENTITY_LOOKUP.get(block));
  }

  @Contract("null -> null")
  public <T extends class_1792> T asItem(@Nullable class_1935 convertible) {
    return convertible != null ? Utilities.cast(convertible.method_8389()) : null;
  }

  public <T extends class_1703> Supplier<class_3917<T>> screenHandlerType(
      BiFunction<Integer, class_1661, T> factory) {
    return Suppliers.memoize(() -> new class_3917<>(factory::apply, class_7699.method_45397()));
  }

  public <T extends class_2586> Supplier<class_2591<T>> blockEntityType(
      BiFunction<class_2338, class_2680, T> factory, class_2248... blocks) {
    return Suppliers.memoize(() -> new class_2591<>(factory::apply, Set.of(blocks), null));
  }

  public <V, T extends V> @Nullable T register(
      class_2378<V> registry, class_2960 id, Supplier<T> entry) {
    return register(true, registry, id, entry);
  }

  public <V, T extends V> @Nullable T register(
      @NotNull BooleanSupplier condition,
      class_2378<V> registry,
      class_2960 id,
      Supplier<T> entry) {
    return register(condition.getAsBoolean(), registry, id, entry);
  }

  public <V, T extends V> @Nullable T register(
      boolean condition, class_2378<V> registry, class_2960 id, Supplier<T> entry) {
    if (condition) {
      return class_2378.method_10230(registry, id, entry.get());
    }
    return null;
  }
}
