package dev.zenfyr.pulsar.resources;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3302;
import net.minecraft.class_3505;
import net.minecraft.class_5349;
import net.minecraft.class_60;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Getter
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
@Accessors(fluent = true)
public final class ReloaderType<T extends class_3302> {

  public static final ReloaderType<class_3505> TAGS = create(ResourceReloadListenerKeys.TAGS);
  public static final ReloaderType<class_1863> RECIPES =
      create(ResourceReloadListenerKeys.RECIPES);
  public static final ReloaderType<class_2989> ADVANCEMENTS =
      create(ResourceReloadListenerKeys.ADVANCEMENTS);
  public static final ReloaderType<class_5349> FUNCTIONS =
      create(ResourceReloadListenerKeys.FUNCTIONS);
  public static final ReloaderType<class_60> LOOT_TABLES =
      create(ResourceReloadListenerKeys.LOOT_TABLES);

  private final class_2960 identifier;

  @Contract("_ -> new")
  public static <T extends class_3302> @NotNull ReloaderType<T> create(
      class_2960 identifier) {
    return new ReloaderType<>(identifier);
  }
}
