package dev.zenfyr.pulsar.resources.impl;

import dev.zenfyr.pulsar.resources.ReloaderType;
import dev.zenfyr.pulsar.resources.ServerReloadersEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_3302;
import net.minecraft.class_5455;
import net.minecraft.class_7699;

public record ContextImpl(
    class_5455.class_6890 registryManager,
    class_7699 enabledFeatures,
    Consumer<IdentifiableResourceReloadListener> registrar,
    Function<ReloaderType<?>, class_3302> provider)
    implements ServerReloadersEvent.Context {

  public void register(IdentifiableResourceReloadListener listener) {
    registrar().accept(listener);
  }

  @Override
  public <T extends class_3302> T reloader(ReloaderType<T> type) {
    return (T) provider().apply(type);
  }
}
