package dev.zenfyr.pulsar.saveddata;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.experimental.UtilityClass;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@UtilityClass
@ApiStatus.Experimental
public final class SavedDataHelper {

  public static <T extends class_18> T getOrCreate(
      @NotNull class_3218 world,
      Function<class_2487, T> readFunction,
      Supplier<T> supplier,
      String id) {
    return world.method_17983().method_17924(readFunction, supplier, id);
  }

  public static <T extends class_18 & DeserializableData> T getOrCreate(
      class_3218 world, Supplier<T> supplier, String id) {
    return getOrCreate(
        world,
        nbt -> {
          T state = supplier.get();
          state.readNbt(nbt);
          return state;
        },
        supplier,
        id);
  }

  public static boolean isStateLoaded(@NotNull class_3218 world, String id) {
    return world.method_17983().field_134.containsKey(id);
  }

  public static <T extends class_18> void consumeIfLoaded(
      class_3218 world,
      String id,
      BiFunction<class_3218, String, T> getFunc,
      Consumer<T> action) {
    if (isStateLoaded(world, id)) {
      action.accept(getFunc.apply(world, id));
    }
  }

  public static <T extends class_18, R> Optional<R> processIfLoaded(
      class_3218 world,
      String id,
      BiFunction<class_3218, String, T> getFunc,
      Function<T, R> action) {
    if (isStateLoaded(world, id)) {
      return Optional.ofNullable(action.apply(getFunc.apply(world, id)));
    }
    return Optional.empty();
  }
}
