package dev.zenfyr.pulsar.util;

import lombok.experimental.UtilityClass;

@UtilityClass
public class ColorUtil {

  public static int toColor(float r, float g, float b) {
    return toColor((int) (r * 255 + 0.5), (int) (g * 255 + 0.5), (int) (b * 255 + 0.5));
  }

  public static int toColor(float r, float g, float b, float a) {
    return toColor(
        (int) (r * 255 + 0.5), (int) (g * 255 + 0.5), (int) (b * 255 + 0.5), (int) (a * 255 + 0.5));
  }

  public static int toColor(int r, int g, int b) {
    return toColor(r, g, b, 255);
  }

  public static int toColor(int r, int g, int b, int a) {
    return a << 24 | r << 16 | g << 8 | b;
  }

  public static int getAlpha(int color) {
    return color >> 24 & 0xFF;
  }

  public static int getRed(int color) {
    return color >> 16 & 0xFF;
  }

  public static int getGreen(int color) {
    return color >> 8 & 0xFF;
  }

  public static int getBlue(int color) {
    return color & 0xFF;
  }

  public static float getAlphaF(int color) {
    return (color >> 24 & 0xFF) / 255f;
  }

  public static float getRedF(int color) {
    return (color >> 16 & 0xFF) / 255f;
  }

  public static float getGreenF(int color) {
    return (color >> 8 & 0xFF) / 255f;
  }

  public static float getBlueF(int color) {
    return (color & 0xFF) / 255f;
  }

  public static int HSBtoRGB(float hue, float saturation, float brightness) {
    int r = 0, g = 0, b = 0;
    if (saturation == 0) {
      r = g = b = (int) (brightness * 255.0f + 0.5f);
    } else {
      float h = (hue - (float) Math.floor(hue)) * 6.0f;
      float f = h - (float) Math.floor(h);
      float p = brightness * (1.0f - saturation);
      float q = brightness * (1.0f - saturation * f);
      float t = brightness * (1.0f - (saturation * (1.0f - f)));
      switch ((int) h) {
        case 0 -> {
          r = (int) (brightness * 255.0f + 0.5f);
          g = (int) (t * 255.0f + 0.5f);
          b = (int) (p * 255.0f + 0.5f);
        }
        case 1 -> {
          r = (int) (q * 255.0f + 0.5f);
          g = (int) (brightness * 255.0f + 0.5f);
          b = (int) (p * 255.0f + 0.5f);
        }
        case 2 -> {
          r = (int) (p * 255.0f + 0.5f);
          g = (int) (brightness * 255.0f + 0.5f);
          b = (int) (t * 255.0f + 0.5f);
        }
        case 3 -> {
          r = (int) (p * 255.0f + 0.5f);
          g = (int) (q * 255.0f + 0.5f);
          b = (int) (brightness * 255.0f + 0.5f);
        }
        case 4 -> {
          r = (int) (t * 255.0f + 0.5f);
          g = (int) (p * 255.0f + 0.5f);
          b = (int) (brightness * 255.0f + 0.5f);
        }
        case 5 -> {
          r = (int) (brightness * 255.0f + 0.5f);
          g = (int) (p * 255.0f + 0.5f);
          b = (int) (q * 255.0f + 0.5f);
        }
      }
    }
    return 0xff000000 | (r << 16) | (g << 8) | b;
  }
}
