package dev.zenfyr.pulsar.util;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.experimental.UtilityClass;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import org.jetbrains.annotations.NotNull;

@UtilityClass
@SuppressWarnings("unused")
public class PlayerUtil {

  public static List<class_1657> getPlayers(
      class_4051 targetPredicate, class_1937 world, class_238 box) {
    return world.method_18456().stream()
        .filter(playerEntity ->
            box.method_1008(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321())
                && targetPredicate.method_18419(null, playerEntity))
        .collect(ImmutableList.toImmutableList());
  }

  public static List<class_1657> findPlayersInRange(class_1937 world, class_2338 pos, int range) {
    return getPlayers(
        class_4051.method_36626().method_18418(range), world, new class_238(pos).method_1014(range));
  }

  public static List<class_1657> findNonCreativePlayersInRange(class_1937 world, class_2338 pos, int range) {
    return findPlayersInRange(world, pos, range).stream()
        .filter(player -> !player.method_7337())
        .collect(ImmutableList.toImmutableList());
  }

  public static @NotNull Optional<class_1657> findClosestPlayerInRange(
      class_1937 world, class_2338 pos, int range) {
    return findPlayersInRange(world, pos, range).stream()
        .min(Comparator.comparingDouble(
            player -> player.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260())));
  }

  public static @NotNull Optional<class_1657> findClosestNonCreativePlayerInRange(
      class_1937 world, class_2338 pos, int range) {
    return findNonCreativePlayersInRange(world, pos, range).stream()
        .min(Comparator.comparingDouble(
            player -> player.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260())));
  }
}
