/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates;

import net.skyenetwork.skyecrates.commands.SkyeCratesCommand;
import net.skyenetwork.skyecrates.config.ConfigManager;
import net.skyenetwork.skyecrates.crates.CrateManager;
import net.skyenetwork.skyecrates.listeners.CrateListener;
import net.skyenetwork.skyecrates.particles.ParticleManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkyeCratesPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private CrateManager crateManager;
    private ParticleManager particleManager;

    public void onEnable() {
        try {
            this.getLogger().info("Starting SkyeCrates plugin...");
            this.configManager = new ConfigManager(this);
            this.crateManager = new CrateManager(this);
            this.particleManager = new ParticleManager(this);
            this.getLogger().info("Loading configuration...");
            this.configManager.loadConfig();
            this.crateManager.loadCrates();
            this.getLogger().info("Registering commands...");
            if (this.getCommand("skyecrates") != null) {
                this.getCommand("skyecrates").setExecutor((CommandExecutor)new SkyeCratesCommand(this));
            }
            this.getLogger().info("Registering listeners...");
            this.getServer().getPluginManager().registerEvents((Listener)new CrateListener(this), (Plugin)this);
            this.getLogger().info("Starting particle manager...");
            this.particleManager.start();
            this.getLogger().info("SkyeCrates has been enabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to enable SkyeCrates: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        if (this.particleManager != null) {
            this.particleManager.stop();
        }
        this.getLogger().info("SkyeCrates has been disabled!");
    }

    public void reload() {
        this.configManager.loadConfig();
        this.crateManager.loadCrates();
        this.particleManager.reload();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CrateManager getCrateManager() {
        return this.crateManager;
    }

    public ParticleManager getParticleManager() {
        return this.particleManager;
    }
}

