/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import net.skyenetwork.skyecrates.crates.CrateManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SkyeCratesCommand
implements CommandExecutor,
TabCompleter {
    private final SkyeCratesPlugin plugin;
    private final MiniMessage miniMessage;

    public SkyeCratesCommand(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("skyecrates.admin")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "give": {
                this.handleGive(sender, args);
                break;
            }
            case "place": {
                this.handlePlace(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender);
                break;
            }
            case "givekey": {
                this.handleGiveKey(sender, args);
                break;
            }
            case "keys": {
                this.handleKeys(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.miniMessage.deserialize((Object)"<gold>=== SkyeCrates Commands ==="));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates reload <gray>- Reload plugin configuration"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates list <gray>- List all available crates"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates give <player> <crate> [amount] <gray>- Give a crate placer to a player"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates place <crate> <gray>- Place a crate at your target location"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates remove <gray>- Remove a crate you're looking at"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates givekey <player> <crate> [amount] <gray>- Give keys to a player"));
        sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>/skyecrates keys <gray>- Show your key counts"));
    }

    private void handleReload(CommandSender sender) {
        this.plugin.reload();
        sender.sendMessage(this.plugin.getConfigManager().getMessage("config-reloaded", new String[0]));
    }

    private void handleList(CommandSender sender) {
        Map<String, CrateManager.CrateConfig> crates = this.plugin.getCrateManager().getAllCrates();
        if (crates.isEmpty()) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>No crates found!"));
            return;
        }
        sender.sendMessage(this.miniMessage.deserialize((Object)"<gold>=== Available Crates ==="));
        for (Map.Entry<String, CrateManager.CrateConfig> entry : crates.entrySet()) {
            String key = entry.getKey();
            CrateManager.CrateConfig crate = entry.getValue();
            sender.sendMessage(this.miniMessage.deserialize((Object)("<yellow>" + key + " <gray>- <white>" + crate.getName())));
        }
    }

    private void handleGive(CommandSender sender, String[] args) {
        Player target;
        if (args.length < 3) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>Usage: /skyecrates give <player> <crate> [amount]"));
            return;
        }
        String targetName = args[1];
        String crateName = args[2];
        int amount = 1;
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.miniMessage.deserialize((Object)("<red>Invalid amount: " + args[3])));
                return;
            }
        }
        if ((target = Bukkit.getPlayer((String)targetName)) == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-not-found", new String[0]));
            return;
        }
        CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
        if (crate == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-not-found", new String[0]));
            return;
        }
        ItemStack crateItem = new ItemStack(Material.PAPER, amount);
        ItemMeta meta = crateItem.getItemMeta();
        if (meta != null) {
            meta.displayName(this.miniMessage.deserialize((Object)("<gold>" + crate.getName() + " Placer")));
            meta.lore(Arrays.asList(this.miniMessage.deserialize((Object)"<gray>Right-click on a block to place this crate!"), this.miniMessage.deserialize((Object)("<yellow>Crate: " + crate.getName()))));
            NamespacedKey nbtKey = new NamespacedKey((Plugin)this.plugin, "crate_type");
            meta.getPersistentDataContainer().set(nbtKey, PersistentDataType.STRING, (Object)crateName);
            crateItem.setItemMeta(meta);
        }
        target.getInventory().addItem(new ItemStack[]{crateItem});
        sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-given", "amount", String.valueOf(amount), "crate", crate.getName(), "player", target.getName()));
    }

    private void handlePlace(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>This command can only be used by players!"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>Usage: /skyecrates place <crate>"));
            return;
        }
        Player player = (Player)sender;
        String crateName = args[1];
        CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
        if (crate == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-not-found", new String[0]));
            return;
        }
        Block targetBlock = player.getTargetBlockExact(10);
        if (targetBlock == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target-block", new String[0]));
            return;
        }
        this.plugin.getCrateManager().placeCrate(targetBlock.getLocation(), crateName);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-placed", "crate", crate.getName()));
    }

    private void handleRemove(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>This command can only be used by players!"));
            return;
        }
        Player player = (Player)sender;
        Block targetBlock = player.getTargetBlockExact(10);
        if (targetBlock == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-crate-to-remove", new String[0]));
            return;
        }
        if (this.plugin.getCrateManager().removeCrate(targetBlock.getLocation())) {
            targetBlock.setType(Material.AIR);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-removed", new String[0]));
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-crate-to-remove", new String[0]));
        }
    }

    private void handleGiveKey(CommandSender sender, String[] args) {
        Player target;
        if (args.length < 3) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>Usage: /skyecrates givekey <player> <crate> [amount]"));
            return;
        }
        String targetName = args[1];
        String crateName = args[2];
        int amount = 1;
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.miniMessage.deserialize((Object)("<red>Invalid amount: " + args[3])));
                return;
            }
        }
        if ((target = Bukkit.getPlayer((String)targetName)) == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-not-found", new String[0]));
            return;
        }
        CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
        if (crate == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("crate-not-found", new String[0]));
            return;
        }
        this.plugin.getCrateManager().addKeys(target, crateName, amount);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("key-given", "amount", String.valueOf(amount), "crate", crate.getName(), "player", target.getName()));
        target.sendMessage(this.plugin.getConfigManager().getMessage("key-received", "amount", String.valueOf(amount), "crate", crate.getName()));
    }

    private void handleKeys(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<red>This command can only be used by players!"));
            return;
        }
        Player player = (Player)sender;
        Map<String, Integer> playerKeys = this.plugin.getCrateManager().getPlayerKeys(player);
        if (playerKeys.isEmpty()) {
            sender.sendMessage(this.miniMessage.deserialize((Object)"<yellow>You don't have any keys!"));
            return;
        }
        sender.sendMessage(this.miniMessage.deserialize((Object)"<gold>=== Your Keys ==="));
        for (Map.Entry<String, Integer> entry : playerKeys.entrySet()) {
            String crateName = entry.getKey();
            int keyCount = entry.getValue();
            CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
            String displayName = crate != null ? crate.getName() : crateName;
            sender.sendMessage(this.miniMessage.deserialize((Object)("<yellow>" + displayName + " <gray>- <white>" + keyCount + " key" + (keyCount == 1 ? "" : "s"))));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("skyecrates.admin")) {
            return new ArrayList<String>();
        }
        switch (args.length) {
            case 1: {
                return Arrays.asList("reload", "list", "give", "place", "remove", "givekey", "keys").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            case 2: {
                switch (args[0].toLowerCase()) {
                    case "give": 
                    case "givekey": {
                        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                    }
                    case "place": {
                        return this.plugin.getCrateManager().getAllCrates().keySet().stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                    }
                }
                return new ArrayList<String>();
            }
            case 3: {
                if ("give".equals(args[0].toLowerCase()) || "givekey".equals(args[0].toLowerCase())) {
                    return this.plugin.getCrateManager().getAllCrates().keySet().stream().filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                }
                return new ArrayList<String>();
            }
            case 4: {
                if ("give".equals(args[0].toLowerCase()) || "givekey".equals(args[0].toLowerCase())) {
                    return Arrays.asList("1", "5", "10");
                }
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }
}

