/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.config;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SkyeCratesPlugin plugin;
    private FileConfiguration config;
    private final MiniMessage miniMessage;
    private String pluginName;
    private Component pluginPrefix;
    private long particleInterval;
    private boolean forceParticles;

    public ConfigManager(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.pluginName = this.config.getString("plugin.name", "SkyeCrates");
        String prefixString = this.config.getString("plugin.prefix", "<gray>[<gold>SkyeCrates<gray>]</gray>");
        this.pluginPrefix = this.miniMessage.deserialize((Object)prefixString);
        this.particleInterval = this.config.getLong("particle-interval", 20L);
        this.forceParticles = "force".equalsIgnoreCase(this.config.getString("particle-mode", "normal"));
    }

    public Component getMessage(String key, String ... replacements) {
        String messageString = this.config.getString("messages." + key, "<red>Message not found: " + key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            String placeholder = replacements[i];
            String value = replacements[i + 1];
            messageString = messageString.replace("{" + placeholder + "}", value);
        }
        Component message = this.miniMessage.deserialize((Object)messageString);
        return this.pluginPrefix.append((Component)Component.space()).append(message);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Component getPluginPrefix() {
        return this.pluginPrefix;
    }

    public long getParticleInterval() {
        return this.particleInterval;
    }

    public boolean isForceParticles() {
        return this.forceParticles;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

