/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.crates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CrateManager {
    private final SkyeCratesPlugin plugin;
    private final Map<String, CrateConfig> crates;
    private final Map<Location, String> placedCrates;
    private final Map<UUID, Map<String, Integer>> playerKeys;

    public CrateManager(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.crates = new HashMap<String, CrateConfig>();
        this.placedCrates = new HashMap<Location, String>();
        this.playerKeys = new HashMap<UUID, Map<String, Integer>>();
    }

    public void loadCrates() {
        File[] crateFiles;
        this.crates.clear();
        File cratesDir = new File(this.plugin.getDataFolder(), "crates");
        if (!cratesDir.exists()) {
            cratesDir.mkdirs();
        }
        if ((crateFiles = cratesDir.listFiles((dir, name) -> name.endsWith(".yml"))) == null || crateFiles.length == 0) {
            this.plugin.saveResource("crates/example.yml", false);
        }
        if ((crateFiles = cratesDir.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : crateFiles) {
                this.loadCrate(file);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.crates.size() + " crate(s)");
    }

    private void loadCrate(File file) {
        try {
            Particle particleType;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            String crateName = file.getName().replace(".yml", "");
            String name = config.getString("name", crateName);
            try {
                String particleTypeString = config.getString("particles.type", "FLAME");
                particleType = Particle.valueOf((String)particleTypeString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid particle type in " + file.getName() + ", using FLAME");
                particleType = Particle.FLAME;
            }
            ParticleConfig particles = new ParticleConfig(particleType, config.getDouble("particles.deltaX", 0.5), config.getDouble("particles.deltaY", 0.5), config.getDouble("particles.deltaZ", 0.5), config.getInt("particles.count", 15), config.getDouble("particles.speed", 0.1));
            String lootJson = config.getString("loot");
            if (lootJson == null) {
                this.plugin.getLogger().warning("No loot table found in " + file.getName());
                return;
            }
            try {
                JsonParser.parseString((String)lootJson);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Invalid JSON in loot table for " + file.getName() + ": " + e.getMessage());
                return;
            }
            CrateConfig crateConfig = new CrateConfig(name, particles, lootJson);
            this.crates.put(crateName, crateConfig);
            this.plugin.getLogger().info("Loaded crate: " + crateName);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load crate from " + file.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public List<ItemStack> generateLootFromCrate(String crateName) {
        CrateConfig crate = this.getCrate(crateName);
        if (crate == null) {
            return new ArrayList<ItemStack>();
        }
        return this.generateLootFromJson(crate.getLootJson(), new Random());
    }

    private List<ItemStack> generateLootFromJson(String lootJson, Random random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try {
            JsonObject jsonObject = JsonParser.parseString((String)lootJson).getAsJsonObject();
            JsonArray pools = jsonObject.getAsJsonArray("pools");
            if (pools != null) {
                for (JsonElement poolElement : pools) {
                    JsonObject pool = poolElement.getAsJsonObject();
                    int rolls = pool.has("rolls") ? pool.get("rolls").getAsInt() : 1;
                    JsonArray entries = pool.getAsJsonArray("entries");
                    for (int i = 0; i < rolls; ++i) {
                        if (entries == null) continue;
                        for (JsonElement entryElement : entries) {
                            String materialName;
                            Material material;
                            int weight;
                            JsonObject entry = entryElement.getAsJsonObject();
                            String type = entry.has("type") ? entry.get("type").getAsString() : "";
                            if (!"minecraft:item".equals(type)) continue;
                            String itemName = entry.has("name") ? entry.get("name").getAsString() : "";
                            int n = weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
                            if (random.nextInt(100) >= weight * 10 || (material = Material.matchMaterial((String)(materialName = itemName.replace("minecraft:", "").toUpperCase()))) == null) continue;
                            int amount = 1;
                            if (entry.has("functions")) {
                                JsonArray functions = entry.getAsJsonArray("functions");
                                for (JsonElement functionElement : functions) {
                                    JsonObject function = functionElement.getAsJsonObject();
                                    String functionType = function.has("function") ? function.get("function").getAsString() : "";
                                    if (!"minecraft:set_count".equals(functionType) || !function.has("count")) continue;
                                    JsonObject count = function.getAsJsonObject("count");
                                    int min = count.has("min") ? count.get("min").getAsInt() : 1;
                                    int max = count.has("max") ? count.get("max").getAsInt() : 1;
                                    amount = random.nextInt(max - min + 1) + min;
                                }
                            }
                            items.add(new ItemStack(material, amount));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error parsing loot table: " + e.getMessage());
            items.add(new ItemStack(Material.STONE));
        }
        return items;
    }

    public CrateConfig getCrate(String name) {
        return this.crates.get(name);
    }

    public Map<String, CrateConfig> getAllCrates() {
        return new HashMap<String, CrateConfig>(this.crates);
    }

    public void placeCrate(Location location, String crateName) {
        if (this.crates.containsKey(crateName)) {
            this.placedCrates.put(location, crateName);
            location.getBlock().setType(Material.BARRIER);
        }
    }

    public boolean removeCrate(Location location) {
        return this.placedCrates.remove(location) != null;
    }

    public String getCrateAt(Location location) {
        return this.placedCrates.get(location);
    }

    public Map<Location, String> getPlacedCrates() {
        return new HashMap<Location, String>(this.placedCrates);
    }

    public boolean openCrate(Location location, Player player) {
        String crateName = this.getCrateAt(location);
        if (crateName == null) {
            return false;
        }
        CrateConfig crate = this.getCrate(crateName);
        if (crate == null) {
            return false;
        }
        if (!this.hasKey(player, crateName)) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-key", "crate", crate.getName()));
            return false;
        }
        if (!this.useKey(player, crateName)) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-key", "crate", crate.getName()));
            return false;
        }
        List<ItemStack> loot = this.generateLootFromCrate(crateName);
        for (ItemStack item : loot) {
            HashMap remaining = player.getInventory().addItem(new ItemStack[]{item});
            for (ItemStack dropItem : remaining.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), dropItem);
            }
        }
        player.sendMessage(this.plugin.getConfigManager().getMessage("crate-opened", "crate", crate.getName()));
        return true;
    }

    public void addKeys(Player player, String crateName, int amount) {
        UUID playerId = player.getUniqueId();
        this.playerKeys.computeIfAbsent(playerId, k -> new HashMap());
        this.playerKeys.get(playerId).merge(crateName, amount, Integer::sum);
    }

    public boolean hasKey(Player player, String crateName) {
        UUID playerId = player.getUniqueId();
        return this.playerKeys.containsKey(playerId) && this.playerKeys.get(playerId).getOrDefault(crateName, 0) > 0;
    }

    public boolean useKey(Player player, String crateName) {
        UUID playerId = player.getUniqueId();
        if (!this.hasKey(player, crateName)) {
            return false;
        }
        Map<String, Integer> keys = this.playerKeys.get(playerId);
        int currentKeys = keys.get(crateName);
        if (currentKeys > 1) {
            keys.put(crateName, currentKeys - 1);
        } else {
            keys.remove(crateName);
        }
        return true;
    }

    public int getKeyCount(Player player, String crateName) {
        UUID playerId = player.getUniqueId();
        return ((Map)this.playerKeys.getOrDefault(playerId, new HashMap())).getOrDefault(crateName, 0);
    }

    public Map<String, Integer> getPlayerKeys(Player player) {
        UUID playerId = player.getUniqueId();
        return new HashMap<String, Integer>(this.playerKeys.getOrDefault(playerId, new HashMap()));
    }

    public static class ParticleConfig {
        private final Particle type;
        private final double deltaX;
        private final double deltaY;
        private final double deltaZ;
        private final int count;
        private final double speed;

        public ParticleConfig(Particle type, double deltaX, double deltaY, double deltaZ, int count, double speed) {
            this.type = type;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.deltaZ = deltaZ;
            this.count = count;
            this.speed = speed;
        }

        public Particle getType() {
            return this.type;
        }

        public double getDeltaX() {
            return this.deltaX;
        }

        public double getDeltaY() {
            return this.deltaY;
        }

        public double getDeltaZ() {
            return this.deltaZ;
        }

        public int getCount() {
            return this.count;
        }

        public double getSpeed() {
            return this.speed;
        }
    }

    public static class CrateConfig {
        private final String name;
        private final ParticleConfig particles;
        private final String lootJson;

        public CrateConfig(String name, ParticleConfig particles, String lootJson) {
            this.name = name;
            this.particles = particles;
            this.lootJson = lootJson;
        }

        public String getName() {
            return this.name;
        }

        public ParticleConfig getParticles() {
            return this.particles;
        }

        public String getLootJson() {
            return this.lootJson;
        }
    }
}

