/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import net.skyenetwork.skyecrates.crates.CrateManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CratePreviewGUI
implements Listener {
    private final SkyeCratesPlugin plugin;
    private final MiniMessage miniMessage;

    public CratePreviewGUI(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void openPreview(Player player, String crateName) {
        ItemStack filler;
        ItemMeta fillerMeta;
        CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
        if (crate == null) {
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)this.miniMessage.deserialize((Object)("<gold>Preview: " + crate.getName())));
        List<PreviewItem> previewItems = this.parsePreviewItems(crate.getLootJson());
        int slot = 0;
        for (PreviewItem previewItem : previewItems) {
            if (slot >= 54) break;
            ItemStack displayItem = previewItem.item.clone();
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                ArrayList<String> lore = new ArrayList<String>();
                if (meta.hasLore() && meta.lore() != null) {
                    for (Component component : meta.lore()) {
                        lore.add((String)this.miniMessage.serialize(component));
                    }
                }
                lore.add("");
                lore.add((String)this.miniMessage.serialize(this.miniMessage.deserialize((Object)("<gray>Weight: <white>" + previewItem.weight))));
                int totalWeight = previewItems.stream().mapToInt(p -> p.weight).sum();
                double chance = (double)previewItem.weight / (double)totalWeight * 100.0;
                lore.add((String)this.miniMessage.serialize(this.miniMessage.deserialize((Object)("<gray>Chance: <yellow>" + String.format("%.1f", chance) + "%"))));
                if (previewItem.minCount != previewItem.maxCount) {
                    lore.add((String)this.miniMessage.serialize(this.miniMessage.deserialize((Object)("<gray>Amount: <white>" + previewItem.minCount + "-" + previewItem.maxCount))));
                } else if (previewItem.minCount > 1) {
                    lore.add((String)this.miniMessage.serialize(this.miniMessage.deserialize((Object)("<gray>Amount: <white>" + previewItem.minCount))));
                }
                meta.lore(lore.stream().map(arg_0 -> ((MiniMessage)this.miniMessage).deserialize(arg_0)).toList());
                displayItem.setItemMeta(meta);
            }
            gui.setItem(slot++, displayItem);
        }
        if ((fillerMeta = (filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE)).getItemMeta()) != null) {
            fillerMeta.displayName(this.miniMessage.deserialize((Object)"<gray> "));
            filler.setItemMeta(fillerMeta);
        }
        for (int i = slot; i < 54; ++i) {
            gui.setItem(i, filler);
        }
        player.openInventory(gui);
    }

    private List<PreviewItem> parsePreviewItems(String lootJson) {
        ArrayList<PreviewItem> items = new ArrayList<PreviewItem>();
        try {
            JsonObject jsonObject = JsonParser.parseString((String)lootJson).getAsJsonObject();
            JsonArray pools = jsonObject.getAsJsonArray("pools");
            if (pools != null) {
                for (JsonElement poolElement : pools) {
                    JsonObject pool = poolElement.getAsJsonObject();
                    JsonArray entries = pool.getAsJsonArray("entries");
                    if (entries == null) continue;
                    for (JsonElement entryElement : entries) {
                        int weight;
                        JsonObject entry = entryElement.getAsJsonObject();
                        String type = entry.has("type") ? entry.get("type").getAsString() : "";
                        if (!"minecraft:item".equals(type)) continue;
                        String itemName = entry.has("name") ? entry.get("name").getAsString() : "";
                        int n = weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
                        String materialName = itemName.replace("minecraft:", "").toUpperCase();
                        Material material = Material.matchMaterial((String)materialName);
                        if (material == null) continue;
                        int minCount = 1;
                        int maxCount = 1;
                        if (entry.has("functions")) {
                            JsonArray functions = entry.getAsJsonArray("functions");
                            for (JsonElement functionElement : functions) {
                                JsonObject function = functionElement.getAsJsonObject();
                                String functionType = function.has("function") ? function.get("function").getAsString() : "";
                                if (!"minecraft:set_count".equals(functionType) || !function.has("count")) continue;
                                JsonObject count = function.getAsJsonObject("count");
                                minCount = count.has("min") ? count.get("min").getAsInt() : 1;
                                maxCount = count.has("max") ? count.get("max").getAsInt() : 1;
                            }
                        }
                        items.add(new PreviewItem(new ItemStack(material), weight, minCount, maxCount));
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error parsing loot table for preview: " + e.getMessage());
        }
        return items;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (this.miniMessage.stripTags(title).startsWith("Preview:")) {
            event.setCancelled(true);
        }
    }

    private static class PreviewItem {
        ItemStack item;
        int weight;
        int minCount;
        int maxCount;

        PreviewItem(ItemStack item, int weight, int minCount, int maxCount) {
            this.item = item;
            this.weight = weight;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }
    }
}

