/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.gui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DeleteConfirmationGUI
implements Listener {
    private final SkyeCratesPlugin plugin;
    private final MiniMessage miniMessage;
    private final Map<UUID, DeleteSession> deleteSessions;
    private final Random random;

    public DeleteConfirmationGUI(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.deleteSessions = new HashMap<UUID, DeleteSession>();
        this.random = new Random();
    }

    public void openDeleteConfirmation(Player player, Location crateLocation, String crateName) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (Component)this.miniMessage.deserialize((Object)"<red>Confirm Crate Deletion"));
        ItemStack grayGlass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = grayGlass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.displayName(this.miniMessage.deserialize((Object)"<gray> "));
            grayGlass.setItemMeta(glassMeta);
        }
        for (int i = 0; i < 27; ++i) {
            gui.setItem(i, grayGlass);
        }
        int redstoneSlot = this.random.nextInt(27);
        ItemStack redstoneBlock = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta redstoneMeta = redstoneBlock.getItemMeta();
        if (redstoneMeta != null) {
            redstoneMeta.displayName(this.miniMessage.deserialize((Object)"<red>Click to Delete Crate"));
            redstoneMeta.lore(Arrays.asList(this.miniMessage.deserialize((Object)("<yellow>Crate: " + crateName)), this.miniMessage.deserialize((Object)"<gray>Click 3 times to confirm deletion"), this.miniMessage.deserialize((Object)"<red>Clicks remaining: 3")));
            redstoneBlock.setItemMeta(redstoneMeta);
        }
        gui.setItem(redstoneSlot, redstoneBlock);
        DeleteSession session = new DeleteSession(crateLocation, crateName, redstoneSlot, 3);
        this.deleteSessions.put(player.getUniqueId(), session);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int newSlot;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!this.miniMessage.stripTags(title).equals("Confirm Crate Deletion")) {
            return;
        }
        event.setCancelled(true);
        DeleteSession session = this.deleteSessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() != Material.REDSTONE_BLOCK) {
            return;
        }
        --session.clicksRemaining;
        if (session.clicksRemaining <= 0) {
            this.plugin.getCrateManager().removeCrate(session.location);
            session.location.getBlock().setType(Material.AIR);
            player.sendMessage(this.plugin.getConfigManager().getMessage("crate-removed", new String[0]));
            player.closeInventory();
            this.deleteSessions.remove(player.getUniqueId());
            return;
        }
        Inventory inv = event.getInventory();
        ItemStack grayGlass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = grayGlass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.displayName(this.miniMessage.deserialize((Object)"<gray> "));
            grayGlass.setItemMeta(glassMeta);
        }
        inv.setItem(session.redstoneSlot, grayGlass);
        session.redstoneSlot = newSlot = this.random.nextInt(27);
        ItemStack redstoneBlock = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta redstoneMeta = redstoneBlock.getItemMeta();
        if (redstoneMeta != null) {
            redstoneMeta.displayName(this.miniMessage.deserialize((Object)"<red>Click to Delete Crate"));
            redstoneMeta.lore(Arrays.asList(this.miniMessage.deserialize((Object)("<yellow>Crate: " + session.crateName)), this.miniMessage.deserialize((Object)"<gray>Click 3 times to confirm deletion"), this.miniMessage.deserialize((Object)("<red>Clicks remaining: " + session.clicksRemaining))));
            redstoneBlock.setItemMeta(redstoneMeta);
        }
        inv.setItem(newSlot, redstoneBlock);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        if (this.miniMessage.stripTags(title).equals("Confirm Crate Deletion")) {
            this.deleteSessions.remove(player.getUniqueId());
        }
    }

    private static class DeleteSession {
        Location location;
        String crateName;
        int redstoneSlot;
        int clicksRemaining;

        DeleteSession(Location location, String crateName, int redstoneSlot, int clicksRemaining) {
            this.location = location;
            this.crateName = crateName;
            this.redstoneSlot = redstoneSlot;
            this.clicksRemaining = clicksRemaining;
        }
    }
}

