/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.listeners;

import net.kyori.adventure.text.minimessage.MiniMessage;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import net.skyenetwork.skyecrates.crates.CrateManager;
import net.skyenetwork.skyecrates.gui.CratePreviewGUI;
import net.skyenetwork.skyecrates.gui.DeleteConfirmationGUI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CrateListener
implements Listener {
    private final SkyeCratesPlugin plugin;
    private final MiniMessage miniMessage;
    private final CratePreviewGUI previewGUI;
    private final DeleteConfirmationGUI deleteGUI;

    public CrateListener(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.previewGUI = new CratePreviewGUI(plugin);
        this.deleteGUI = new DeleteConfirmationGUI(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this.previewGUI, (Plugin)plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this.deleteGUI, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        String crateName;
        ItemMeta meta;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        Block clickedBlock = event.getClickedBlock();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && item != null && item.getType() == Material.PAPER && (meta = item.getItemMeta()) != null) {
            NamespacedKey nbtKey = new NamespacedKey((Plugin)this.plugin, "crate_type");
            String crateType = (String)meta.getPersistentDataContainer().get(nbtKey, PersistentDataType.STRING);
            if (crateType != null && clickedBlock != null) {
                Location placeLocation = clickedBlock.getLocation().add(0.0, 1.0, 0.0);
                if (placeLocation.getBlock().getType() == Material.AIR) {
                    this.plugin.getCrateManager().placeCrate(placeLocation, crateType);
                    item.setAmount(item.getAmount() - 1);
                    CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateType);
                    if (crate != null) {
                        player.sendMessage(this.plugin.getConfigManager().getMessage("crate-placed", "crate", crate.getName()));
                    }
                    event.setCancelled(true);
                } else {
                    player.sendMessage(this.plugin.getConfigManager().getMessage("crate-place-blocked", new String[0]));
                    event.setCancelled(true);
                }
            }
        }
        if (clickedBlock != null && clickedBlock.getType() == Material.BARRIER && (crateName = this.plugin.getCrateManager().getCrateAt(clickedBlock.getLocation())) != null) {
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (player.isSneaking() && player.hasPermission("skyecrates.admin")) {
                    CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
                    if (crate != null) {
                        this.deleteGUI.openDeleteConfirmation(player, clickedBlock.getLocation(), crate.getName());
                    }
                } else {
                    this.previewGUI.openPreview(player, crateName);
                }
                event.setCancelled(true);
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (player.hasPermission("skyecrates.use")) {
                    this.plugin.getCrateManager().openCrate(clickedBlock.getLocation(), player);
                } else {
                    player.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
                }
                event.setCancelled(true);
            }
        }
    }
}

