/*
 * Decompiled with CFR 0.152.
 */
package net.skyenetwork.skyecrates.particles;

import java.util.Map;
import net.skyenetwork.skyecrates.SkyeCratesPlugin;
import net.skyenetwork.skyecrates.crates.CrateManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ParticleManager {
    private final SkyeCratesPlugin plugin;
    private BukkitTask particleTask;

    public ParticleManager(SkyeCratesPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.stop();
        this.particleTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::spawnParticles, 0L, this.plugin.getConfigManager().getParticleInterval());
    }

    public void stop() {
        if (this.particleTask != null) {
            this.particleTask.cancel();
            this.particleTask = null;
        }
    }

    public void reload() {
        this.start();
    }

    private void spawnParticles() {
        Map<Location, String> placedCrates = this.plugin.getCrateManager().getPlacedCrates();
        for (Map.Entry<Location, String> entry : placedCrates.entrySet()) {
            Location location = entry.getKey();
            String crateName = entry.getValue();
            CrateManager.CrateConfig crate = this.plugin.getCrateManager().getCrate(crateName);
            if (crate == null) continue;
            CrateManager.ParticleConfig particles = crate.getParticles();
            Location particleLocation = location.clone().add(0.5, 1.5, 0.5);
            if (this.plugin.getConfigManager().isForceParticles()) {
                if (location.getWorld() == null) continue;
                location.getWorld().spawnParticle(particles.getType(), particleLocation, particles.getCount(), particles.getDeltaX(), particles.getDeltaY(), particles.getDeltaZ(), particles.getSpeed(), null, true);
                continue;
            }
            if (location.getWorld() == null) continue;
            location.getWorld().spawnParticle(particles.getType(), particleLocation, particles.getCount(), particles.getDeltaX(), particles.getDeltaY(), particles.getDeltaZ(), particles.getSpeed());
        }
    }
}

