/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.teamtagger.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.numbits.teamtagger.manager.ColorConfigManager;
import dev.numbits.teamtagger.manager.TeamListManager;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_640;

public class TeamTaggerCommands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> TeamTaggerCommands.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tt").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(TeamTaggerCommands.onlinePlayersSuggestion()).executes(ctx -> TeamTaggerCommands.addPlayer((CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(TeamTaggerCommands.teamListSuggestion()).executes(ctx -> TeamTaggerCommands.removePlayer((CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"teamcolor").then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).executes(ctx -> TeamTaggerCommands.setTeamColor((CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"enemycolor").then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).executes(ctx -> TeamTaggerCommands.setEnemyColor((CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"teamtag").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
            b.suggest("on");
            b.suggest("off");
            return CompletableFuture.completedFuture(b.build());
        }).executes(ctx -> TeamTaggerCommands.setTeamTagState((CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"enemytag").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
            b.suggest("on");
            b.suggest("off");
            return CompletableFuture.completedFuture(b.build());
        }).executes(ctx -> TeamTaggerCommands.setEnemyTagState((CommandContext<FabricClientCommandSource>)ctx)))));
    }

    private static int setTeamTagState(CommandContext<FabricClientCommandSource> ctx) {
        String state = StringArgumentType.getString(ctx, (String)"state");
        Boolean enabled = TeamTaggerCommands.parseOnOff(state);
        if (enabled == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Use : /tt teamtag <on|off>"));
            return 0;
        }
        ColorConfigManager.setTeamEnabled(enabled);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Team name tags " + (enabled != false ? "\u00a7aON" : "\u00a7cOFF"))));
        return 1;
    }

    private static int setEnemyTagState(CommandContext<FabricClientCommandSource> ctx) {
        String state = StringArgumentType.getString(ctx, (String)"state");
        Boolean enabled = TeamTaggerCommands.parseOnOff(state);
        if (enabled == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Use : /tt enemytag <on|off>"));
            return 0;
        }
        ColorConfigManager.setEnemyEnabled(enabled);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Enemy name tags " + (enabled != false ? "\u00a7aON" : "\u00a7cOFF"))));
        return 1;
    }

    private static Boolean parseOnOff(String s) {
        String v = s.toLowerCase();
        if (v.equals("on")) {
            return true;
        }
        if (v.equals("off")) {
            return false;
        }
        return null;
    }

    private static SuggestionProvider<FabricClientCommandSource> onlinePlayersSuggestion() {
        return (context, builder) -> {
            class_310 client = class_310.method_1551();
            if (client.method_1562() != null) {
                for (class_640 entry : client.method_1562().method_2880()) {
                    String name = entry.method_2966().getName();
                    if (!class_2172.method_27136((String)builder.getRemaining(), (String)name)) continue;
                    builder.suggest(name);
                }
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }

    private static SuggestionProvider<FabricClientCommandSource> teamListSuggestion() {
        return (context, builder) -> {
            for (String name : TeamListManager.getAll()) {
                if (!class_2172.method_27136((String)builder.getRemaining(), (String)name)) continue;
                builder.suggest(name);
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }

    private static int addPlayer(CommandContext<FabricClientCommandSource> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        boolean added = TeamListManager.addPlayer(name);
        if (added) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Added teammate : \u00a7b" + name)));
        } else {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a7b" + name + " \u00a77is already in team list.")));
        }
        return 1;
    }

    private static int removePlayer(CommandContext<FabricClientCommandSource> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        boolean removed = TeamListManager.removePlayer(name);
        if (removed) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Removed teammate : \u00a7b" + name)));
        } else {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a7c" + name + " \u00a77not found in team list.")));
        }
        return 1;
    }

    private static int setTeamColor(CommandContext<FabricClientCommandSource> ctx) {
        String code = StringArgumentType.getString(ctx, (String)"color");
        class_5251 color = TeamTaggerCommands.parseColor(code);
        if (color == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Invalid color code. Use RRGGBB or #RRGGBB."));
            return 0;
        }
        ColorConfigManager.setTeamColor(color);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Team color set to #" + String.format("%06X", color.method_27716() & 0xFFFFFF))));
        return 1;
    }

    private static int setEnemyColor(CommandContext<FabricClientCommandSource> ctx) {
        String code = StringArgumentType.getString(ctx, (String)"color");
        class_5251 color = TeamTaggerCommands.parseColor(code);
        if (color == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Invalid color code. Use RRGGBB or #RRGGBB."));
            return 0;
        }
        ColorConfigManager.setEnemyColor(color);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[\u00a7dTeamTagger\u00a77] \u00a77Enemy color set to #" + String.format("%06X", color.method_27716() & 0xFFFFFF))));
        return 1;
    }

    private static class_5251 parseColor(String code) {
        String hex = code.trim();
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6) {
            return null;
        }
        try {
            int rgb = (int)Long.parseLong(hex, 16);
            return class_5251.method_27717((int)rgb);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

